/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;

public class GetFileContentOperation
extends AbstractFileOperation {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected Revision revision;
    protected Revision pegRevision;
    protected int bufferSize;
    protected OutputStream target;

    public GetFileContentOperation(File file, Revision revision, Revision pegRevision, OutputStream target) {
        this(file, revision, pegRevision, 2048, target);
    }

    public GetFileContentOperation(File file, Revision revision, Revision pegRevision, int bufferSize, OutputStream target) {
        super("Operation.GetFileContent", new File[]{file});
        this.revision = revision;
        this.pegRevision = pegRevision;
        this.bufferSize = bufferSize;
        this.target = target;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File file = this.operableData()[0];
        IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(file, false);
        ISVNClientWrapper proxy = remote.getRepositoryLocation().acquireSVNProxy();
        try {
            int kind = this.revision.getKind();
            if (kind == 5 || kind == 6) {
                proxy.streamFileContent(file.getAbsolutePath(), this.revision, null, this.bufferSize, this.target, new SVNProgressMonitor(this, monitor, null));
            } else {
                proxy.streamFileContent(SVNUtility.encodeURL(remote.getUrl()), this.revision, this.pegRevision, this.bufferSize, this.target, new SVNProgressMonitor(this, monitor, null));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
            remote.getRepositoryLocation().releaseSVNProxy(proxy);
            return;
        }
    }
}

