/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.file.AbstractStatusOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class RemoteStatusOperation
extends AbstractStatusOperation
implements Notify2 {
    protected Map pegRevisions = new HashMap();

    public RemoteStatusOperation(File[] files, boolean recursive) {
        super("Operation.UpdateStatusFile", files, recursive);
    }

    public RemoteStatusOperation(IFileProvider provider, boolean recursive) {
        super("Operation.UpdateStatusFile", provider, recursive);
    }

    public Revision getPegRevision(File change) {
        Path resourcePath = new Path(change.getAbsolutePath());
        Iterator it = this.pegRevisions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Path rootPath = new Path((String)entry.getKey());
            if (!rootPath.isPrefixOf((IPath)resourcePath)) continue;
            return (Revision)entry.getValue();
        }
        return null;
    }

    public void onNotify(NotifyInformation info) {
        if (info.revision != -1L) {
            this.pegRevisions.put(info.path, Revision.getInstance(info.revision));
        }
    }

    protected void reportStatuses(ISVNClientWrapper proxy, List result, File current, IProgressMonitor monitor, int tasks) {
        SVNUtility.addSVNNotifyListener(proxy, this);
        super.reportStatuses(proxy, result, current, monitor, tasks);
        SVNUtility.removeSVNNotifyListener(proxy, this);
    }

    protected boolean isRemote() {
        return true;
    }
}

