/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileConflictDetectionOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class UpdateOperation
extends AbstractFileConflictDetectionOperation
implements IFileProvider {
    protected boolean updateUnresolved;
    protected Revision selectedRevision;

    public UpdateOperation(File[] files, Revision selectedRevision, boolean updateUnresolved) {
        super("Operation.UpdateFile", files);
        this.updateUnresolved = updateUnresolved;
        this.selectedRevision = selectedRevision;
    }

    public UpdateOperation(IFileProvider provider, Revision selectedRevision, boolean updateUnresolved) {
        super("Operation.UpdateFile", provider);
        this.updateUnresolved = updateUnresolved;
        this.selectedRevision = selectedRevision;
    }

    public File[] getFiles() {
        return this.getProcessed();
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        this.defineInitialResourceSet(files);
        Map wc2Resources = SVNUtility.splitWorkingCopies(files);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            IRepositoryResource wcRoot = SVNFileStorage.instance().asRepositoryResource((File)entry.getKey(), false);
            final IRepositoryLocation location = wcRoot.getRepositoryLocation();
            final String[] paths = FileUtility.asPathArray(((List)entry.getValue()).toArray(new File[0]));
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    UpdateOperation.this.writeToConsole(0, "svn update");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        UpdateOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    UpdateOperation.this.writeToConsole(0, " -r " + UpdateOperation.this.selectedRevision + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            proxy.setTouchUnresolved(this.updateUnresolved);
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.update(paths, UpdateOperation.this.selectedRevision, true, false, new ConflictDetectionProgressMonitor(UpdateOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            proxy.setTouchUnresolved(false);
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
            super.progress(current, total, state);
            if (state.contentState == 8 || state.propState == 8) {
                UpdateOperation.this.hasUnresolvedConflict = true;
                UpdateOperation.this.unprocessed.add(new File(state.path));
                Path conflictPath = new Path(state.path);
                Iterator it = UpdateOperation.this.processed.iterator();
                while (it.hasNext()) {
                    File res = (File)it.next();
                    if (!new Path(res.getAbsolutePath()).equals((Object)conflictPath)) continue;
                    it.remove();
                    break;
                }
            }
        }
    }
}

