/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.property;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;

public class SetPropertyOperation
extends AbstractFileOperation {
    protected PropertyData[] propertyData;
    protected boolean isRecursive;

    public SetPropertyOperation(File[] files, String name, byte[] data, boolean isRecursive) {
        this(files, new PropertyData[]{new PropertyData(name, null, data)}, isRecursive);
    }

    public SetPropertyOperation(File[] files, PropertyData[] data, boolean isRecursive) {
        super("Operation.SetPropertiesFile", files);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertyOperation(IFileProvider provider, String name, byte[] data, boolean isRecursive) {
        this(provider, new PropertyData[]{new PropertyData(name, null, data)}, isRecursive);
    }

    public SetPropertyOperation(IFileProvider provider, PropertyData[] data, boolean isRecursive) {
        super("Operation.SetPropertiesFile", provider);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = this.operableData();
        if (this.isRecursive) {
            files = FileUtility.shrinkChildNodes(files, false);
        }
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = remote.getRepositoryLocation();
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < SetPropertyOperation.this.propertyData.length && !monitor.isCanceled()) {
                        PropertyData property = SetPropertyOperation.this.propertyData[i];
                        SetPropertyOperation.this.protectStep(new IUnprotectedOperation(this, proxy, current, property){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ISVNClientWrapper val$proxy;
                            private final /* synthetic */ File val$current;
                            private final /* synthetic */ PropertyData val$property;
                            {
                                this.this$1 = var1_1;
                                this.val$proxy = iSVNClientWrapper;
                                this.val$current = file;
                                this.val$property = propertyData;
                            }

                            public void run(IProgressMonitor monitor) throws Exception {
                                this.val$proxy.propertySet(this.val$current.getAbsolutePath(), this.val$property.name, this.val$property.data, 1.access$0(this.this$1).isRecursive, (ISVNProgressMonitor)new SVNProgressMonitor(1.access$0(this.this$1), monitor, null));
                            }
                        }, monitor, SetPropertyOperation.this.propertyData.length);
                        ++i;
                    }
                }

                static /* synthetic */ SetPropertyOperation access$0(1 var0) {
                    return var0.SetPropertyOperation.this;
                }
            }, monitor, files.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected ISchedulingRule getSchedulingRule(File file) {
        return file.isDirectory() ? new AbstractFileOperation.LockingRule(file) : super.getSchedulingRule(file);
    }
}

