/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.file.refactor;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.file.AbstractFileOperation;
import org.polarion.team.svn.core.operation.file.IFileProvider;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class DeleteOperation
extends AbstractFileOperation {
    public DeleteOperation(File[] files) {
        super("Operation.DeleteFile", files);
    }

    public DeleteOperation(IFileProvider provider) {
        super("Operation.DeleteFile", provider);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] files = FileUtility.shrinkChildNodes(this.operableData(), false);
        int i = 0;
        while (i < files.length && !monitor.isCanceled()) {
            final File current = files[i];
            IRepositoryResource remote = SVNFileStorage.instance().asRepositoryResource(current, true);
            if (remote == null) {
                ProgressMonitorUtility.setTaskInfo(monitor, this, current.getAbsolutePath());
                FileUtility.deleteRecursive(current, monitor);
                ProgressMonitorUtility.progress(monitor, i, files.length);
            } else {
                IRepositoryLocation location = remote.getRepositoryLocation();
                final ISVNClientWrapper proxy = location.acquireSVNProxy();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        DeleteOperation.this.writeToConsole(0, "svn delete \"" + FileUtility.normalizePath(current.getAbsolutePath()) + "\" --force\n");
                        proxy.remove(new String[]{current.getAbsolutePath()}, "", true, new SVNProgressMonitor(DeleteOperation.this, monitor, null));
                    }
                }, monitor, files.length);
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }
}

