/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class AddToSVNOperation
extends AbstractWorkingCopyOperation {
    protected boolean isRecursive;

    public AddToSVNOperation(IResource[] resources) {
        this(resources, false);
    }

    public AddToSVNOperation(IResource[] resources, boolean isRecursive) {
        super("Operation.AddToSVN", resources);
        this.isRecursive = isRecursive;
    }

    public AddToSVNOperation(IResourceProvider provider) {
        this(provider, false);
    }

    public AddToSVNOperation(IResourceProvider provider, boolean isRecursive) {
        super("Operation.AddToSVN", provider);
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            boolean bl = this.isRecursive = !FileUtility.checkForResourcesPresenceRecursive(resources, IStateFilter.SF_IGNORED);
        }
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        } else {
            FileUtility.reorder(resources, true);
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            IRepositoryLocation location = storage.getRepositoryLocation(current);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AddToSVNOperation.this.doAdd(current, proxy, monitor);
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    public static void removeFromParentIgnore(ISVNClientWrapper proxy, String parentPath, String name) throws Exception {
        PropertyData data = proxy.propertyGet(parentPath, "svn:ignore", new SVNNullProgressMonitor());
        String ignoreValue = data == null ? "" : data.value;
        StringTokenizer tok = new StringTokenizer(ignoreValue, "\n", true);
        ignoreValue = "";
        boolean skipToken = false;
        while (tok.hasMoreTokens()) {
            String oneOf = tok.nextToken();
            if (!oneOf.equals(name) && !skipToken) {
                ignoreValue = String.valueOf(ignoreValue) + oneOf;
                continue;
            }
            boolean bl = skipToken = !skipToken;
        }
        if (ignoreValue.length() > 0) {
            proxy.propertySet(parentPath, "svn:ignore", ignoreValue, false, (ISVNProgressMonitor)new SVNNullProgressMonitor());
        } else {
            proxy.propertyRemove(parentPath, "svn:ignore", false, new SVNNullProgressMonitor());
        }
    }

    protected void doAdd(IResource current, ISVNClientWrapper proxy, IProgressMonitor monitor) throws Exception {
        String wcPath = FileUtility.getWorkingCopyPath(current);
        this.writeToConsole(0, "svn add \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.isRecursive ? "" : " -N") + "\n");
        IContainer parent = current.getParent();
        if (parent != null) {
            AddToSVNOperation.removeFromParentIgnore(proxy, FileUtility.getWorkingCopyPath((IResource)parent), current.getName());
        }
        proxy.add(wcPath, this.isRecursive, new SVNProgressMonitor(this, monitor, null));
    }
}

