/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResource destination;
    protected String message;

    public BranchTagOperation(String operationName, IResource[] resources, IRepositoryResource destination, String message) {
        super("Operation." + operationName, resources);
        this.destination = destination;
        this.message = message;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        final ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            final String destinationUrl = SVNUtility.encodeURL(this.destination.getUrl());
            int i = 0;
            while (i < resources.length) {
                final String wcPath = FileUtility.getWorkingCopyPath((IResource)resources[i]);
                Notify2 notify = new Notify2(){

                    public void onNotify(NotifyInformation info) {
                        if (info.revision != -1L) {
                            String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                            BranchTagOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                        }
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, notify);
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        BranchTagOperation.this.writeToConsole(0, "svn copy \"" + wcPath + "\" \"" + destinationUrl + "\" -r " + Revision.WORKING + " -m \"" + BranchTagOperation.this.message + "\"" + FileUtility.getUsernameParam(BranchTagOperation.this.destination.getRepositoryLocation().getUsername()) + "\n");
                        proxy.copy(wcPath, destinationUrl, BranchTagOperation.this.message, Revision.WORKING, new SVNProgressMonitor(BranchTagOperation.this, monitor, null));
                    }
                }, monitor, resources.length);
                SVNUtility.removeSVNNotifyListener(proxy, notify);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var9_11 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

