/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class InfoOperation
extends AbstractNonLockingOperation {
    protected IResource resource;
    protected ILocalResource local;
    protected Info2 info;

    public InfoOperation(IResource resource) {
        super("Operation.Info");
        this.resource = resource;
    }

    public Info2 getInfo() {
        return this.info;
    }

    public ILocalResource getLocal() {
        return this.local;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.info = null;
        this.local = SVNRemoteStorage.instance().asLocalResource(this.resource);
        if (this.local == null) return;
        if (!IStateFilter.SF_ONREPOSITORY.accept(this.resource, this.local.getStatus(), this.local.getChangeMask())) return;
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.resource);
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            Info2[] infos = proxy.info2(FileUtility.getWorkingCopyPath(this.resource), Revision.WORKING, null, false, new SVNProgressMonitor(this, monitor, null));
            if (infos != null && infos.length > 0) {
                this.info = infos[0];
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var5_7 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.resource.getName());
    }
}

