/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class JavaHLMergeOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResource[] from1;
    protected IRepositoryResource[] from2;
    protected boolean dryRun;
    protected boolean ignoreAncestry;
    protected ISVNProgressMonitor externalMonitor;

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResource[] from1, IRepositoryResource[] from2, boolean dryRun) {
        this(localTo, from1, from2, dryRun, false);
    }

    public JavaHLMergeOperation(IResource[] localTo, IRepositoryResource[] from1, IRepositoryResource[] from2, boolean dryRun, boolean ignoreAncestry) {
        super("Operation.JavaHLMerge", localTo);
        this.from1 = from1;
        this.from2 = from2;
        this.dryRun = dryRun;
        this.ignoreAncestry = ignoreAncestry;
    }

    public void setExternalMonitor(ISVNProgressMonitor externalMonitor) {
        this.externalMonitor = externalMonitor;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource resource = resources[i];
            final IRepositoryResource from1 = this.from1[i];
            final IRepositoryResource from2 = this.from2[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    JavaHLMergeOperation.this.doMerge(resource, from1, from2, monitor);
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doMerge(IResource resource, IRepositoryResource from1, IRepositoryResource from2, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = from1.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        proxy.setTouchUnresolved(true);
        try {
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            if (from1.getUrl().equals(from2.getUrl())) {
                this.writeToConsole(0, "svn merge -r " + from1.getSelectedRevision() + ":" + from2.getSelectedRevision() + "\"" + from1.getUrl() + "@" + from1.getPegRevision() + "\" \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.dryRun ? " --dry-run" : "") + (this.ignoreAncestry ? " --ignore-ancestry" : "") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.merge(SVNUtility.encodeURL(from1.getUrl()), from1.getPegRevision(), from1.getSelectedRevision(), from2.getSelectedRevision(), wcPath, false, true, this.ignoreAncestry, this.dryRun, (ISVNProgressMonitor)new MergeProgressMonitor(this, monitor, null));
            } else {
                this.writeToConsole(0, "svn merge \"" + from1.getUrl() + "@" + from1.getSelectedRevision() + "\" \"" + from2.getUrl() + "@" + from2.getSelectedRevision() + "\" \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.dryRun ? " --dry-run" : "") + (this.ignoreAncestry ? " --ignore-ancestry" : "") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.merge(SVNUtility.encodeURL(from1.getUrl()), from1.getSelectedRevision(), SVNUtility.encodeURL(from2.getUrl()), from2.getSelectedRevision(), wcPath, false, true, this.ignoreAncestry, this.dryRun, (ISVNProgressMonitor)new MergeProgressMonitor(this, monitor, null));
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            proxy.setTouchUnresolved(false);
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var8_10 = null;
            proxy.setTouchUnresolved(false);
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected class MergeProgressMonitor
    extends SVNProgressMonitor {
        public MergeProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root, !JavaHLMergeOperation.this.dryRun);
        }

        public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
            super.progress(current, total, state);
            if (JavaHLMergeOperation.this.externalMonitor != null) {
                JavaHLMergeOperation.this.externalMonitor.progress(current, total, state);
            }
        }
    }
}

