/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.polarion.team.svn.core.operation.local.MergeSet;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;

public class MergeOperation
extends AbstractConflictDetectionOperation
implements IResourceProvider {
    protected MergeSet info;
    protected boolean force;

    public MergeOperation(IResource[] resources, MergeSet info, boolean force) {
        super("Operation.Merge", resources);
        this.info = info;
        this.force = force;
    }

    public MergeOperation(IResourceProvider provider, MergeSet info, boolean force) {
        super("Operation.Merge", provider);
        this.info = info;
        this.force = force;
    }

    public IResource[] getResources() {
        return this.getProcessed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] localTo = this.operableData();
        this.defineInitialResourceSet(localTo);
        localTo = FileUtility.shrinkChildNodes(localTo);
        ArrayList<Status> retVal = new ArrayList<Status>();
        int i = 0;
        while (i < localTo.length && !monitor.isCanceled()) {
            Status st = this.getStatusFor(localTo[i]);
            if (st != null) {
                retVal.add(st);
            }
            ++i;
        }
        Status[] statuses = retVal.toArray(new Status[retVal.size()]);
        IRepositoryResource from = this.info.from[0];
        IRepositoryLocation location = from.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            proxy.merge(null, from.getPegRevision(), this.info.start, from.getSelectedRevision(), null, statuses, this.force, new ConflictDetectionProgressMonitor(this, monitor, null));
            Object var8_11 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
    }

    protected Status getStatusFor(IResource resource) {
        Status[] statuses = this.info.getStatuses();
        IPath target = FileUtility.getResourcePath(resource);
        int i = 0;
        while (i < statuses.length) {
            if (target.equals((Object)new Path(statuses[i].path))) {
                return statuses[i];
            }
            ++i;
        }
        return null;
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
            super.progress(current, total, state);
            if (state.contentState == 8 || state.contentState == 7 || state.propState == 8 || state.propState == 7) {
                MergeOperation.this.hasUnresolvedConflict = true;
                Iterator it = MergeOperation.this.processed.iterator();
                while (it.hasNext()) {
                    IResource res = (IResource)it.next();
                    if (!FileUtility.getResourcePath(res).equals((Object)new Path(state.path))) continue;
                    it.remove();
                    MergeOperation.this.unprocessed.add(res);
                    break;
                }
            }
        }
    }
}

