/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.management;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.SVNTeamProjectMapper;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.management.IShareProjectPrompt;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class ShareProjectOperation
extends AbstractWorkingCopyOperation {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_SINGLE = 1;
    public static final int LAYOUT_MULTIPLE = 2;
    protected IRepositoryLocation location;
    protected IFolderNameMapper mapper;
    protected int shareLayout;
    protected String rootName;
    protected boolean managementFoldersEnabled;
    protected String commitComment;
    protected IShareProjectPrompt shareProjectPrompt;

    public ShareProjectOperation(IProject[] projects, IRepositoryLocation location, IFolderNameMapper mapper) {
        this(projects, location, mapper, null);
    }

    public ShareProjectOperation(IProject[] projects, IRepositoryLocation location, IFolderNameMapper mapper, String commitComment) {
        this(projects, location, mapper, null, 0, true, commitComment);
    }

    public ShareProjectOperation(IProject[] projects, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled) {
        this(projects, location, mapper, rootName, shareLayout, managementFoldersEnabled, null);
    }

    public ShareProjectOperation(IProject[] projects, IRepositoryLocation location, IFolderNameMapper mapper, String rootName, int shareLayout, boolean managementFoldersEnabled, String commitComment) {
        super("Operation.ShareProject", (IResource[])projects);
        this.mapper = mapper;
        this.location = location;
        this.shareLayout = shareLayout;
        this.rootName = rootName;
        this.managementFoldersEnabled = managementFoldersEnabled;
        this.commitComment = commitComment;
    }

    public void setSharePrompt(IShareProjectPrompt prompt) {
        this.shareProjectPrompt = prompt;
    }

    public static String getTargetUrl(IRepositoryLocation location, int shareLayout, String projectName, String rootName, boolean managementFoldersEnabled) {
        return SVNUtility.normalizeURL(ShareProjectOperation.getTargetUrlImpl(location, shareLayout, projectName, rootName, managementFoldersEnabled));
    }

    public static String getDefaultComment(IProject project, IRepositoryResource remote) {
        String message = SVNTeamPlugin.instance().getResource("Operation.ShareProject.DefaultComment");
        return MessageFormat.format(message, project.getName(), remote.getUrl());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        HashMap<IResource, IRepositoryContainer> local2remote;
        block15: {
            Iterator it;
            IResource[] resources = this.operableData();
            local2remote = new HashMap<IResource, IRepositoryContainer>();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    if (this.commitComment == null) {
                        this.commitComment = "";
                        it = local2remote.entrySet().iterator();
                        break;
                    }
                    break block15;
                }
                String url = ShareProjectOperation.getTargetUrl(this.location, this.shareLayout, this.mapper == null ? resources[i].getName() : this.mapper.getRepositoryFolderName((IProject)resources[i]), this.rootName, this.managementFoldersEnabled);
                IRepositoryContainer remote = this.location.asRepositoryContainer(url, false);
                local2remote.put(resources[i], remote);
                ++i;
            }
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String commentPart = ShareProjectOperation.getDefaultComment((IProject)entry.getKey(), (IRepositoryContainer)entry.getValue());
                this.commitComment = String.valueOf(this.commitComment) + (this.commitComment.length() == 0 ? commentPart : "\n" + commentPart);
            }
        }
        Set fullSet = null;
        switch (this.shareLayout) {
            case 0: {
                fullSet = this.doDefaultLayout(local2remote);
                break;
            }
            case 1: {
                fullSet = this.doSingleLayout(local2remote);
                break;
            }
            case 2: {
                fullSet = this.doMultipleLayout(local2remote);
                break;
            }
            default: {
                String message = this.getNationalizedString("Error.UnknownProjectLayoutType");
                throw new Exception(MessageFormat.format(message, String.valueOf(this.shareLayout)));
            }
        }
        final HashSet existingProjects = new HashSet();
        Iterator it = local2remote.entrySet().iterator();
        while (true) {
            if (!it.hasNext() || monitor.isCanceled()) {
                if (existingProjects.size() <= 0 || this.shareProjectPrompt == null || this.shareProjectPrompt.prompt(existingProjects.toArray(new IProject[existingProjects.size()]))) break;
                throw new ClientWrapperCancelException(this.getNationalizedString("Error.ShareCancelled"));
            }
            final Map.Entry entry = it.next();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    try {
                        IRepositoryContainer remote = (IRepositoryContainer)entry.getValue();
                        if (remote.getChildren().length > 0) {
                            existingProjects.add(entry.getKey());
                        }
                    }
                    catch (ClientWrapperException clientWrapperException) {}
                }
            }, monitor, local2remote.size() * 2);
        }
        final ISVNClientWrapper proxy = this.location.acquireSVNProxy();
        try {
            IRepositoryResource[] resourceSet = this.getOrderedSet(fullSet);
            this.mkdir(proxy, resourceSet, monitor);
            Iterator it2 = local2remote.entrySet().iterator();
            while (it2.hasNext() && !monitor.isCanceled()) {
                final Map.Entry entry = it2.next();
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IRepositoryContainer remote = (IRepositoryContainer)entry.getValue();
                        IProject project = (IProject)entry.getKey();
                        File tempDir = existingProjects.contains(project) ? ShareProjectOperation.this.createTempDirectory(project) : null;
                        String checkoutTo = tempDir != null ? tempDir.toString() : FileUtility.getWorkingCopyPath((IResource)project);
                        proxy.checkout(SVNUtility.encodeURL(remote.getUrl()), checkoutTo, Revision.HEAD, Revision.HEAD, true, false, new SVNProgressMonitor(ShareProjectOperation.this, monitor, null));
                        if (tempDir != null) {
                            ShareProjectOperation.this.copySVNMeta(tempDir, FileUtility.getResourcePath((IResource)project).toFile());
                            FileUtility.deleteRecursive(tempDir, monitor);
                        }
                        SVNTeamProjectMapper.map(project, remote);
                    }
                }, monitor, local2remote.size() * 2);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var10_14 = null;
            this.location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected Set doDefaultLayout(Map local2remote) throws Exception {
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        Iterator it = local2remote.values().iterator();
        while (it.hasNext()) {
            IRepositoryContainer remote = (IRepositoryContainer)it.next();
            IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
            fullSet.addAll(Arrays.asList(resources));
        }
        return fullSet;
    }

    protected Set doSingleLayout(Map local2remote) throws Exception {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            Iterator it = local2remote.values().iterator();
            while (it.hasNext()) {
                IRepositoryContainer remote = (IRepositoryContainer)it.next();
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                IRepositoryContainer parent = (IRepositoryContainer)remote.getParent();
                fullSet.add(this.makeChild(parent, ShareProjectOperation.getTagsName(this.location)));
                fullSet.add(this.makeChild(parent, ShareProjectOperation.getBranchesName(this.location)));
            }
            return fullSet;
        }
        return this.doDefaultLayout(local2remote);
    }

    protected Set doMultipleLayout(Map local2remote) throws Exception {
        if (this.managementFoldersEnabled) {
            HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
            Iterator it = local2remote.values().iterator();
            while (it.hasNext()) {
                IRepositoryContainer remote = (IRepositoryContainer)it.next();
                IRepositoryResource[] resources = SVNUtility.makeResourceSet(remote.getRepositoryLocation().getRoot(), remote);
                fullSet.addAll(Arrays.asList(resources));
                String targetUrl = ShareProjectOperation.getTargetUrl(this.location, this.shareLayout, "", this.rootName, false);
                IRepositoryContainer parent = this.location.asRepositoryContainer(targetUrl, false);
                fullSet.add(this.makeChild(parent, ShareProjectOperation.getTagsName(this.location)));
                fullSet.add(this.makeChild(parent, ShareProjectOperation.getBranchesName(this.location)));
            }
            return fullSet;
        }
        return this.doDefaultLayout(local2remote);
    }

    protected IRepositoryResource[] getOrderedSet(Set fullSet) {
        Object[] resources = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        FileUtility.sort(resources, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IRepositoryResource first = (IRepositoryResource)arg0;
                IRepositoryResource second = (IRepositoryResource)arg1;
                return first.getUrl().compareTo(second.getUrl());
            }
        });
        return resources;
    }

    protected void mkdir(ISVNClientWrapper proxy, IRepositoryResource[] resourceSet, IProgressMonitor monitor) throws Exception {
        ArrayList<String> urlsList = new ArrayList<String>();
        int i = 0;
        while (i < resourceSet.length && !monitor.isCanceled()) {
            ProgressMonitorUtility.setTaskInfo(monitor, this, resourceSet[i].getUrl());
            if (!resourceSet[i].exists()) {
                urlsList.add(SVNUtility.encodeURL(resourceSet[i].getUrl()));
            }
            ProgressMonitorUtility.progress(monitor, -1, resourceSet.length);
            ++i;
        }
        String[] urls = urlsList.toArray(new String[urlsList.size()]);
        proxy.mkdir(urls, this.commitComment, new SVNProgressMonitor(this, monitor, null));
    }

    protected IRepositoryContainer makeChild(IRepositoryContainer parent, String name) {
        return this.location.asRepositoryContainer(String.valueOf(parent.getUrl()) + "/" + name, false);
    }

    protected File createTempDirectory(IProject project) {
        try {
            File tempDirectory = File.createTempFile("save_" + project.getName(), ".tmp", FileUtility.getResourcePath((IResource)project).toFile().getParentFile());
            tempDirectory.deleteOnExit();
            tempDirectory.delete();
            return tempDirectory;
        }
        catch (IOException ex) {
            String message = SVNTeamPlugin.instance().getResource("Error.CannotCheckOutMeta");
            throw new UnreportableException(MessageFormat.format(message, String.valueOf(project.getName())), ex);
        }
    }

    protected void copySVNMeta(File fromFolder, File toFolder) {
        if (!toFolder.isDirectory()) {
            return;
        }
        File[] tempFiles = fromFolder.listFiles();
        if (tempFiles != null) {
            int i = 0;
            while (i < tempFiles.length) {
                File renameToFile = new File(toFolder + "/" + tempFiles[i].getName());
                if (!renameToFile.exists()) {
                    tempFiles[i].renameTo(renameToFile);
                } else if (tempFiles[i].isDirectory()) {
                    this.copySVNMeta(tempFiles[i], renameToFile);
                }
                ++i;
            }
        }
    }

    protected static String getTargetUrlImpl(IRepositoryLocation location, int shareLayout, String projectName, String rootName, boolean managementFoldersEnabled) {
        String trunkName = managementFoldersEnabled ? "/" + ShareProjectOperation.getTrunkName(location) : "";
        switch (shareLayout) {
            case 0: {
                return String.valueOf(location.getUrl()) + trunkName + "/" + projectName;
            }
            case 1: {
                return String.valueOf(location.getUrl()) + "/" + projectName + trunkName;
            }
            case 2: {
                return String.valueOf(location.getUrl()) + "/" + rootName + trunkName + "/" + projectName;
            }
        }
        String message = SVNTeamPlugin.instance().getResource("Error.UnknownProjectLayoutType");
        throw new RuntimeException(MessageFormat.format(message, String.valueOf(shareLayout)));
    }

    public static String getTrunkName(IRepositoryLocation location) {
        if (location.isStructureEnabled()) {
            return location.getTrunkLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTrunkName();
    }

    public static String getBranchesName(IRepositoryLocation location) {
        if (location.isStructureEnabled()) {
            return location.getBranchesLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultBranchesName();
    }

    public static String getTagsName(IRepositoryLocation location) {
        if (location.isStructureEnabled()) {
            return location.getTagsLocation();
        }
        return SVNTeamPlugin.instance().getOptionProvider().getDefaultTagsName();
    }

    public static interface IFolderNameMapper {
        public String getRepositoryFolderName(IProject var1);
    }
}

