/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.property;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.property.IPropertyProvider;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class GetMultiPropertiesOperation
extends AbstractNonLockingOperation
implements IResourceProvider,
IPropertyProvider {
    protected IResource[] resources;
    protected HashMap properties;
    protected String propertyName;
    protected int depth;
    protected IStateFilter filter;

    public GetMultiPropertiesOperation(IResource[] resources, int depth, IStateFilter filter, String propertyName) {
        super("Operation.GetMultiProperties");
        this.resources = resources;
        this.propertyName = propertyName;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
        this.properties = new HashMap();
        this.depth = depth;
    }

    public IResource[] getResources() {
        Set resources = this.properties.keySet();
        return resources.toArray(new IResource[resources.size()]);
    }

    public PropertyData[] getProperties(IResource resource) {
        return (PropertyData[])this.properties.get(resource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.resources.length && !monitor.isCanceled()) {
            Object var6_6;
            final IResource current = this.resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        FileUtility.visitNodes(current, new IResourceVisitor(this, monitor, proxy){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ ISVNClientWrapper val$proxy;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$proxy = iSVNClientWrapper;
                            }

                            public boolean visit(IResource resource) throws CoreException {
                                if (this.val$monitor.isCanceled()) {
                                    return false;
                                }
                                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                                if (local == null) {
                                    return false;
                                }
                                if (1.access$0(this.this$1).filter.accept(resource, local.getStatus(), local.getChangeMask())) {
                                    1.access$0(this.this$1).processResource(this.val$proxy, resource, this.val$monitor);
                                }
                                return 1.access$0(this.this$1).filter.allowsRecursion(resource, local.getStatus(), local.getChangeMask());
                            }
                        }, GetMultiPropertiesOperation.this.depth);
                    }

                    static /* synthetic */ GetMultiPropertiesOperation access$0(1 var0) {
                        return var0.GetMultiPropertiesOperation.this;
                    }
                }, monitor, this.resources.length);
            }
            catch (Throwable throwable) {
                var6_6 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            {
                var6_6 = null;
                location.releaseSVNProxy(proxy);
                ++i;
                continue;
            }
            break;
        }
        return;
    }

    protected void processResource(final ISVNClientWrapper proxy, final IResource current, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                String wcPath = FileUtility.getWorkingCopyPath(current);
                if (GetMultiPropertiesOperation.this.propertyName != null) {
                    PropertyData data = proxy.propertyGet(wcPath, GetMultiPropertiesOperation.this.propertyName, new SVNProgressMonitor(GetMultiPropertiesOperation.this, monitor, null));
                    if (data != null) {
                        GetMultiPropertiesOperation.this.properties.put(current, new PropertyData[]{data});
                    }
                } else {
                    PropertyData[] data = proxy.properties(wcPath, Revision.BASE, Revision.BASE, new SVNProgressMonitor(GetMultiPropertiesOperation.this, monitor, null));
                    if (data != null && data.length != 0) {
                        GetMultiPropertiesOperation.this.properties.put(current, data);
                    }
                }
            }
        }, monitor, 1);
    }
}

