/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.property;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class GetPropertiesOperation
extends AbstractNonLockingOperation
implements IResourcePropertyProvider {
    protected PropertyData[] properties;
    protected IResource resource;
    protected Revision revision;

    public GetPropertiesOperation(IResource resource) {
        this(resource, Revision.WORKING);
    }

    public GetPropertiesOperation(IResource resource, Revision revision) {
        super("Operation.GetProperties");
        this.resource = resource;
        this.revision = revision;
    }

    public PropertyData[] getProperties() {
        return this.properties;
    }

    public boolean isEditAllowed() {
        return true;
    }

    public void refresh() {
        this.run((IProgressMonitor)new NullProgressMonitor());
    }

    public IResource getLocal() {
        return this.resource;
    }

    public IRepositoryResource getRemote() {
        return SVNRemoteStorage.instance().asRepositoryResource(this.resource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.properties = null;
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.resource);
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            this.properties = proxy.properties(FileUtility.getWorkingCopyPath(this.resource), this.revision, null, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var4_6 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.resource.getName());
    }
}

