/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.refactor;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.SVNResourceRuleFactory;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRemoteStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class DeleteResourceOperation
extends AbstractActionOperation {
    protected IResource[] resources;
    protected static final IStateFilter SF_OBSTRUCTED_OR_NEW = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return IStateFilter.SF_OBSTRUCTED.accept(resource, state, mask) || IStateFilter.SF_NEW.accept(resource, state, mask);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return IStateFilter.SF_OBSTRUCTED.allowsRecursion(resource, state, mask) || IStateFilter.SF_NEW.allowsRecursion(resource, state, mask);
        }
    };

    public DeleteResourceOperation(IResource resource) {
        this(new IResource[]{resource});
    }

    public DeleteResourceOperation(IResource[] resources) {
        super("Operation.DeleteLocal");
        this.resources = resources;
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule[] rules = new ISchedulingRule[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            rules[i] = SVNResourceRuleFactory.INSTANCE.deleteRule(this.resources[i]);
            ++i;
        }
        return new MultiRule(rules);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        ArrayList<IResource> resourcesList = new ArrayList<IResource>(Arrays.asList(this.resources));
        this.cleanupResourcesList(resourcesList, SF_OBSTRUCTED_OR_NEW, storage);
        if (resourcesList.size() == 0) {
            return;
        }
        IResource[] allResources = resourcesList.toArray(new IResource[resourcesList.size()]);
        Map project2Resources = SVNUtility.splitWorkingCopies(allResources);
        Iterator it = project2Resources.entrySet().iterator();
        while (it.hasNext()) {
            Object var13_14;
            Map.Entry entry = it.next();
            IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
            IResource[] resources = ((List)entry.getValue()).toArray(new IResource[((List)entry.getValue()).size()]);
            String[] wcPaths = new String[resources.length];
            String printedPath = "";
            int i = 0;
            while (i < resources.length) {
                wcPaths[i] = FileUtility.getWorkingCopyPath(resources[i]);
                printedPath = String.valueOf(printedPath) + "\"" + FileUtility.normalizePath(wcPaths[i]) + (i < resources.length - 1 ? " " : "") + "\"";
                ++i;
            }
            ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                this.writeToConsole(0, "svn delete " + printedPath + " --force\n");
                proxy.remove(wcPaths, "", true, new SVNProgressMonitor(this, monitor, null));
                var13_14 = null;
                location.releaseSVNProxy(proxy);
            }
            catch (Throwable throwable) {
                var13_14 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
        }
    }

    protected void cleanupResourcesList(List resources, IStateFilter filter, IRemoteStorage storage) {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            IResource resource = (IResource)it.next();
            ILocalResource local = storage.asLocalResource(resource);
            String wcPath = FileUtility.getWorkingCopyPath(resource);
            if (local == null || !filter.accept(resource, local.getStatus(), local.getChangeMask())) continue;
            it.remove();
            FileUtility.deleteRecursive(new File(wcPath));
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        Object[] wcPaths = new String[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            wcPaths[i] = FileUtility.getWorkingCopyPath(this.resources[i]);
            ++i;
        }
        return MessageFormat.format(super.getShortErrorMessage(t), wcPaths);
    }
}

