/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;

public abstract class AbstractCopyMoveResourcesOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected IRepositoryResource destinationResource;
    protected String message;
    protected ArrayList revisionsPairs;

    public AbstractCopyMoveResourcesOperation(String operationName, IRepositoryResource destinationResource, IRepositoryResource[] selectedResources, String message) {
        super(operationName, selectedResources);
        this.destinationResource = destinationResource;
        this.message = message;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        final String dstUrl = this.destinationResource.getUrl();
        IRepositoryResource[] selectedResources = this.operableData();
        int i = 0;
        while (i < selectedResources.length && !monitor.isCanceled()) {
            final IRepositoryResource current = selectedResources[i];
            final IRepositoryLocation location = current.getRepositoryLocation();
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            Notify2 notify = new Notify2(){

                public void onNotify(NotifyInformation info) {
                    String[] paths = AbstractCopyMoveResourcesOperation.this.getRevisionPaths(current.getUrl(), String.valueOf(dstUrl) + "/" + current.getName());
                    AbstractCopyMoveResourcesOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, paths, location));
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                    AbstractCopyMoveResourcesOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                }
            };
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AbstractCopyMoveResourcesOperation.this.processEntry(proxy, SVNUtility.encodeURL(current.getUrl()), SVNUtility.encodeURL(String.valueOf(dstUrl) + "/" + current.getName()), current, monitor);
                }
            }, monitor, selectedResources.length);
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected abstract String[] getRevisionPaths(String var1, String var2);

    protected abstract void processEntry(ISVNClientWrapper var1, String var2, String var3, IRepositoryResource var4, IProgressMonitor var5) throws Exception;
}

