/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String destinationUrl;
    protected String message;
    protected ArrayList revisionsPairs;

    public BranchTagOperation(String operationName, IRepositoryResource[] resources, IRepositoryResource destination, String message) {
        super("Operation." + operationName, resources);
        this.destinationUrl = destination.getUrl();
        this.message = message;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        final IRepositoryLocation location = resources[0].getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            int i = 0;
            while (i < resources.length && !monitor.isCanceled()) {
                Object current = resources[i];
                final String url2 = SVNUtility.encodeURL(this.destinationUrl);
                Notify2 notify = new Notify2(){

                    public void onNotify(NotifyInformation info) {
                        BranchTagOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, new String[]{url2}, location));
                        String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                        BranchTagOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, notify);
                this.protectStep(new IUnprotectedOperation((IRepositoryResource)current, proxy, url2){
                    private final /* synthetic */ IRepositoryResource val$current;
                    private final /* synthetic */ ISVNClientWrapper val$proxy;
                    private final /* synthetic */ String val$url2;
                    {
                        this.val$current = iRepositoryResource;
                        this.val$proxy = iSVNClientWrapper;
                        this.val$url2 = string;
                    }

                    public void run(IProgressMonitor monitor) throws Exception {
                        BranchTagOperation.this.writeToConsole(0, "svn copy \"" + this.val$current.getUrl() + "\" \"" + BranchTagOperation.this.destinationUrl + "\" -r " + this.val$current.getSelectedRevision() + " -m \"" + BranchTagOperation.this.message + "\"" + FileUtility.getUsernameParam(this.val$current.getRepositoryLocation().getUsername()) + "\n");
                        this.val$proxy.copy(SVNUtility.encodeURL(this.val$current.getUrl()), this.val$url2, BranchTagOperation.this.message, this.val$current.getSelectedRevision(), new SVNProgressMonitor(BranchTagOperation.this, monitor, null));
                    }
                }, monitor, resources.length);
                SVNUtility.removeSVNNotifyListener(proxy, notify);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var9_11 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

