/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.polarion.team.svn.core.SVNTeamProjectMapper;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.SVNResourceRuleFactory;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CheckoutAsOperation
extends AbstractActionOperation {
    protected IProject project;
    protected IRepositoryResource resource;
    protected String projectLocation;
    protected List overlappingProjects;
    protected boolean recursive;
    protected RestoreProjectMetaOperation restoreOp;

    public CheckoutAsOperation(String projectName, IRepositoryResource resource, boolean recursive) {
        this(projectName, resource, Platform.getLocation().toString(), recursive);
    }

    public CheckoutAsOperation(String projectName, IRepositoryResource resource, boolean respectHierarchy, String location, boolean recursive) {
        this(projectName, resource, location == null ? Platform.getLocation().toString() : String.valueOf(location) + (respectHierarchy ? SVNUtility.getResourceParent(resource) : ""), recursive);
    }

    public CheckoutAsOperation(String projectName, IRepositoryResource resource, String projectLocation, boolean recursive) {
        super("Operation.CheckOutAs");
        IProject[] projects;
        projectName = FileUtility.formatResourceName(projectName);
        if (FileUtility.isCaseInsensitiveOS()) {
            projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IProject projectToCheckOut = null;
            int i = 0;
            while (i < projects.length) {
                if (projects[i].getName().equalsIgnoreCase(projectName)) {
                    projectToCheckOut = projects[i];
                }
                ++i;
            }
            this.project = projectToCheckOut != null ? projectToCheckOut : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        } else {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        this.resource = resource;
        this.projectLocation = projectLocation;
        this.recursive = recursive;
        this.overlappingProjects = new ArrayList();
        projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (new Path(this.projectLocation).append(this.project.getName()).isPrefixOf(projects[i].getLocation())) {
                this.overlappingProjects.add(projects[i]);
            }
            ++i;
        }
        this.overlappingProjects.add(this.project);
    }

    public ISchedulingRule getSchedulingRule() {
        IProject[] projects = this.overlappingProjects.toArray(new IProject[this.overlappingProjects.size()]);
        ISchedulingRule[] rules = new ISchedulingRule[this.overlappingProjects.size()];
        int i = 0;
        while (i < projects.length) {
            rules[i] = SVNResourceRuleFactory.INSTANCE.modifyRule((IResource)projects[i]);
            ++i;
        }
        return new MultiRule(rules);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setRestoreOperation(RestoreProjectMetaOperation restoreOp) {
        this.restoreOp = restoreOp;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IPath destination = new Path(this.projectLocation).append(this.project.getName());
        ProgressMonitorUtility.doSubTask(this, new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                CheckoutAsOperation.this.doCheckout(monitor, destination);
            }
        }, monitor, 2);
        ProgressMonitorUtility.doSubTask(this, new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                CheckoutAsOperation.this.doOpen(monitor, destination);
            }
        }, monitor, 2);
    }

    protected void doOpen(IProgressMonitor monitor, IPath destination) throws Exception {
        if (this.restoreOp != null) {
            this.reportStatus(this.restoreOp.run(monitor).getStatus());
        }
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.project.getName());
        if (!Platform.getLocation().equals((Object)new Path(this.projectLocation))) {
            description.setLocation(destination);
        }
        this.project.create(description, monitor);
        this.project.open((IProgressMonitor)new SubProgressMonitor(monitor, -1));
        SVNTeamProjectMapper.map(this.project, this.resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCheckout(IProgressMonitor monitor, IPath destination) throws Exception {
        ProgressMonitorUtility.setTaskInfo(monitor, this, this.getOperationResource("PrepareFS"));
        Iterator it = this.overlappingProjects.iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            IProject overlappingProject = (IProject)it.next();
            this.deleteProject(overlappingProject, monitor);
        }
        this.deleteFolderContent(destination.toString(), monitor);
        IRepositoryLocation location = this.resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            String path = destination.toString();
            this.writeToConsole(0, "svn checkout \"" + this.resource.getUrl() + "@" + this.resource.getPegRevision() + "\" -r " + this.resource.getSelectedRevision() + (this.recursive ? "" : " -N") + " \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.checkout(SVNUtility.encodeURL(this.resource.getUrl()), path, this.resource.getSelectedRevision(), this.resource.getPegRevision(), this.recursive, false, new SVNProgressMonitor(this, monitor, this.project.getFullPath()));
            Object var6_8 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
    }

    protected void deleteProject(IProject project, IProgressMonitor monitor) throws Exception {
        IPath location = project.getLocation();
        project.delete(false, true, null);
        if (location != null) {
            this.deleteFolderContent(location.toString(), monitor);
        }
    }

    protected void deleteFolderContent(String targetPath, IProgressMonitor monitor) throws Exception {
        File[] children;
        File target = new File(targetPath);
        if (!FileUtility.deleteRecursive(target, monitor) && (children = target.listFiles()) != null && children.length > 0) {
            String message = this.getNationalizedString("Error.LockedExternally");
            throw new UnreportableException(MessageFormat.format(message, children[0].getAbsolutePath()));
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.resource.getUrl());
    }
}

