/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.remote.CheckoutAsOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class CheckoutOperation
extends AbstractActionOperation
implements IResourceProvider {
    protected HashMap checkoutMap;
    protected IProject[] projects;
    protected CheckoutAsOperation[] operations;
    protected ISchedulingRule rule;

    public CheckoutOperation(HashMap checkoutMap, boolean respectHierarchy, String location, boolean checkoutRecursively) {
        super("Operation.CheckOut");
        this.checkoutMap = checkoutMap;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        ArrayList<CheckoutAsOperation> operations = new ArrayList<CheckoutAsOperation>();
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        Iterator iter = this.checkoutMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            IRepositoryResource currentResource = (IRepositoryResource)this.checkoutMap.get(name);
            CheckoutAsOperation coOp = CheckoutOperation.getCheckoutAsOperation(name, currentResource, respectHierarchy, location, checkoutRecursively);
            operations.add(coOp);
            projects.add(coOp.getProject());
            rules.add(coOp.getSchedulingRule());
        }
        this.rule = new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
        this.projects = projects.toArray(new IProject[projects.size()]);
        this.operations = operations.toArray(new CheckoutAsOperation[operations.size()]);
    }

    public IResource[] getResources() {
        return this.projects;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.rule;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.operations.length && !monitor.isCanceled()) {
            this.operations[i].setConsoleStream(this.getConsoleStream());
            ProgressMonitorUtility.doTask(this.operations[i], monitor, this.checkoutMap.keySet().size());
            this.reportStatus(this.operations[i].getStatus());
            ++i;
        }
    }

    public static CheckoutAsOperation getCheckoutAsOperation(String name, IRepositoryResource currentResource, boolean respectHierarchy, String location, boolean checkoutRecursively) {
        if (location != null && location.trim().length() > 0) {
            return new CheckoutAsOperation(name, currentResource, respectHierarchy, location, checkoutRecursively);
        }
        return new CheckoutAsOperation(name, currentResource, checkoutRecursively);
    }
}

