/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractCopyMoveResourcesOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CopyResourcesOperation
extends AbstractCopyMoveResourcesOperation {
    public CopyResourcesOperation(IRepositoryResource destinationResource, IRepositoryResource[] selectedResources, String message) {
        super("Operation.CopyRemote", destinationResource, selectedResources, message);
    }

    protected String[] getRevisionPaths(String srcUrl, String dstUrl) {
        return new String[]{dstUrl};
    }

    protected void processEntry(ISVNClientWrapper proxy, String sourceUrl, String destinationUrl, IRepositoryResource current, IProgressMonitor monitor) throws Exception {
        this.writeToConsole(0, "svn copy \"" + SVNUtility.decodeURL(sourceUrl) + "\" \"" + SVNUtility.decodeURL(destinationUrl) + "\" -r " + current.getSelectedRevision() + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(current.getRepositoryLocation().getUsername()) + "\n");
        proxy.copy(sourceUrl, destinationUrl, this.message, current.getSelectedRevision(), new SVNProgressMonitor(this, monitor, null));
    }
}

