/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CreateFileOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected String[] fileNames;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFileOperation(IRepositoryResource resource, String path, String message, String[] fileNames) {
        super("Operation.CreateFile", new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.fileNames = fileNames;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IRepositoryResource resource = this.operableData()[0];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        final ISVNClientWrapper proxy = location.acquireSVNProxy();
        Notify2 notify = new Notify2(){

            public void onNotify(NotifyInformation info) {
                if (info.revision != -1L) {
                    String[] path = new String[]{resource.getUrl()};
                    CreateFileOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                    CreateFileOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                }
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            int i = 0;
            while (i < this.fileNames.length) {
                final String[] currentFile = new String[]{this.fileNames[i]};
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        String path = FileUtility.normalizePath(String.valueOf(CreateFileOperation.this.path) + "/" + currentFile[0]);
                        String url = String.valueOf(resource.getUrl()) + "/" + currentFile[0];
                        CreateFileOperation.this.writeToConsole(0, "svn import \"" + path + "\" \"" + url + "\" -m \"" + CreateFileOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + " -N\n");
                        proxy.doImport(path, SVNUtility.encodeURL(url), CreateFileOperation.this.message, false, new SVNProgressMonitor(CreateFileOperation.this, monitor, null));
                    }
                }, monitor, this.fileNames.length);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        SVNUtility.removeSVNNotifyListener(proxy, notify);
        location.releaseSVNProxy(proxy);
    }
}

