/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CreatePatchOperation
extends AbstractRepositoryOperation {
    protected String fileName;
    protected boolean recurse;
    protected boolean ignoreDeleted;
    protected boolean processBinary;
    protected boolean ignoreAncestry;

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary) {
        this(first, second, fileName, recurse, ignoreDeleted, processBinary, true);
    }

    public CreatePatchOperation(IRepositoryResource first, IRepositoryResource second, String fileName, boolean recurse, boolean ignoreDeleted, boolean processBinary, boolean ignoreAncestry) {
        super("Operation.CreatePatchRemote", new IRepositoryResource[]{first, second});
        this.fileName = fileName;
        this.recurse = recurse;
        this.ignoreDeleted = ignoreDeleted;
        this.processBinary = processBinary;
        this.ignoreAncestry = ignoreAncestry;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource first = this.operableData()[0];
        IRepositoryResource second = this.operableData()[1];
        IRepositoryLocation location = first.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn diff \"" + first.getUrl() + "@" + first.getSelectedRevision() + "\" \"" + second.getUrl() + "@" + second.getSelectedRevision() + "\"" + (this.recurse ? "" : " -N") + (this.ignoreDeleted ? " --no-diff-deleted" : "") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.diff(SVNUtility.encodeURL(first.getUrl()), first.getSelectedRevision(), first.getPegRevision(), SVNUtility.encodeURL(second.getUrl()), second.getSelectedRevision(), second.getPegRevision(), this.fileName, this.recurse, this.ignoreAncestry, this.ignoreDeleted, this.processBinary, false, false, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }
}

