/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class DeleteResourcesOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String message;
    protected ArrayList revisionsPairs;

    public DeleteResourcesOperation(IRepositoryResource[] resources, String message) {
        super("Operation.DeleteRemote", resources);
        this.message = message;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        IRepositoryResource[] resources = SVNUtility.shrinkChildNodes(this.operableData());
        Map repository2Resources = SVNUtility.splitRepositoryLocations(resources);
        Iterator it = repository2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            final IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            final String[] paths = SVNUtility.asURLArray(((List)entry.getValue()).toArray(new IRepositoryResource[0]), true);
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    DeleteResourcesOperation.this.writeToConsole(0, "svn delete");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        DeleteResourcesOperation.this.writeToConsole(0, " \"" + SVNUtility.decodeURL(paths[i]) + "\"");
                        ++i;
                    }
                    DeleteResourcesOperation.this.writeToConsole(0, " -m \"" + DeleteResourcesOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            Notify2 notify = new Notify2(){

                public void onNotify(NotifyInformation info) {
                    DeleteResourcesOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(info.revision, paths, location));
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                    DeleteResourcesOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                }
            };
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.remove(paths, DeleteResourcesOperation.this.message, true, new SVNProgressMonitor(DeleteResourcesOperation.this, monitor, null));
                }
            }, monitor, repository2Resources.size());
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }
}

