/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class ExportOperation
extends AbstractRepositoryOperation {
    protected String path;

    public ExportOperation(IRepositoryResource resource, String path) {
        super("Operation.ExportRevision", new IRepositoryResource[]{resource});
        this.path = path;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            String path = String.valueOf(this.path) + "/" + resource.getName();
            this.writeToConsole(0, "svn export \"" + resource.getUrl() + "@" + resource.getPegRevision() + "\" -r " + resource.getSelectedRevision() + " \"" + FileUtility.normalizePath(path) + "\" --force" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.doExport(SVNUtility.encodeURL(resource.getUrl()), path, resource.getSelectedRevision(), resource.getPegRevision(), true, false, true, null, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

