/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class ImportOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected boolean isRecursive;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public ImportOperation(IRepositoryResource resource, String path, String message, boolean isRecursive) {
        super("Operation.Import", new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.isRecursive = isRecursive;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final IRepositoryResource resource = this.operableData()[0];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        Notify2 notify = new Notify2(){

            public void onNotify(NotifyInformation info) {
                if (info.revision != -1L) {
                    String[] path = new String[]{resource.getUrl()};
                    ImportOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                    String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                    ImportOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
                }
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn import \"" + FileUtility.normalizePath(this.path) + "\" \"" + resource.getUrl() + "\"" + (this.isRecursive ? "" : " -N") + " -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.doImport(this.path, SVNUtility.encodeURL(resource.getUrl()), this.message, this.isRecursive, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SVNUtility.removeSVNNotifyListener(proxy, notify);
        location.releaseSVNProxy(proxy);
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

