/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.resource;

import java.io.Serializable;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SSHSettings
implements Serializable {
    private static final long serialVersionUID = 300172856661110588L;
    public static final int SSH_PORT_DEFAULT = 22;
    protected int port = 22;
    protected boolean useKeyFile = false;
    protected String privateKeyPath = "";
    protected String passPhrase = "";
    protected boolean passPhraseSaved = false;
    private transient String passPhraseTemporary;

    public String getPassPhrase() {
        return this.passPhraseSaved ? SVNUtility.base64Decode(this.passPhrase) : SVNUtility.base64Decode(this.passPhraseTemporary);
    }

    public void setPassPhrase(String passPhrase) {
        if (this.passPhraseSaved) {
            this.passPhrase = SVNUtility.base64Encode(passPhrase);
        } else {
            this.passPhraseTemporary = SVNUtility.base64Encode(passPhrase);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public boolean isUseKeyFile() {
        return this.useKeyFile;
    }

    public void setUseKeyFile(boolean useKeyFile) {
        this.useKeyFile = useKeyFile;
    }

    public boolean isPassPhraseSaved() {
        return this.passPhraseSaved;
    }

    public void setPassPhraseSaved(boolean passPhraseSaved) {
        if (this.passPhraseSaved == passPhraseSaved) {
            return;
        }
        this.passPhraseSaved = passPhraseSaved;
        if (!passPhraseSaved) {
            this.passPhraseTemporary = this.passPhrase;
            this.passPhrase = null;
        } else {
            this.passPhrase = this.passPhraseTemporary;
        }
    }
}

