/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.IPath;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.polarion.team.svn.core.utility.SVNUtility;

public abstract class AbstractSVNStorage
implements ISVNStorage {
    protected File stateInfoFile;
    protected IRepositoryLocation[] repositories = new IRepositoryLocation[0];

    public void dispose() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].dispose();
                ++i;
            }
        }
    }

    public void reconfigureLocations() {
        IRepositoryLocation[] locations = this.repositories;
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                locations[i].reconfigure();
                ++i;
            }
        }
    }

    public IRepositoryLocation[] getRepositoryLocations() {
        return this.repositories;
    }

    public IRepositoryLocation getRepositoryLocation(String id) {
        int i = 0;
        while (i < this.repositories.length) {
            if (this.repositories[i].getId().equals(id)) {
                return this.repositories[i];
            }
            ++i;
        }
        return null;
    }

    public IRepositoryLocation newRepositoryLocation() {
        return new SVNRepositoryLocation(new UniversalUniqueIdentifier().toString());
    }

    public void copyRepositoryLocation(IRepositoryLocation to, IRepositoryLocation from) {
        to.setStructureEnabled(from.isStructureEnabled());
        to.setBranchesLocation(from.getUserInputBranches());
        to.setTagsLocation(from.getUserInputTags());
        to.setTrunkLocation(from.getUserInputTrunk());
        to.setUrl(from.getUrlAsIs());
        to.setLabel(from.getLabel());
        to.setUsername(from.getUsername());
        to.setPassword(from.getPassword());
        to.setPasswordSaved(from.isPasswordSaved());
        SSHSettings sshOriginal = from.getSSHSettings();
        SSHSettings sshNew = to.getSSHSettings();
        sshNew.setPassPhrase(sshOriginal.getPassPhrase());
        sshNew.setPassPhraseSaved(sshOriginal.isPassPhraseSaved());
        sshNew.setPort(sshOriginal.getPort());
        sshNew.setPrivateKeyPath(sshOriginal.getPrivateKeyPath());
        sshNew.setUseKeyFile(sshOriginal.isUseKeyFile());
        SSLSettings sslOriginal = from.getSSLSettings();
        SSLSettings sslNew = to.getSSLSettings();
        sslNew.setAuthenticationEnabled(sslOriginal.isAuthenticationEnabled());
        sslNew.setCertificatePath(sslOriginal.getCertificatePath());
        sslNew.setPassPhrase(sslOriginal.getPassPhrase());
        sslNew.setPassPhraseSaved(sslOriginal.isPassPhraseSaved());
        ProxySettings proxyOriginal = from.getProxySettings();
        ProxySettings proxyNew = to.getProxySettings();
        proxyNew.setAuthenticationEnabled(proxyOriginal.isAuthenticationEnabled());
        proxyNew.setEnabled(proxyOriginal.isEnabled());
        proxyNew.setHost(proxyOriginal.getHost());
        proxyNew.setPassword(proxyOriginal.getPassword());
        proxyNew.setPasswordSaved(proxyOriginal.isPasswordSaved());
        proxyNew.setPort(proxyOriginal.getPort());
        proxyNew.setUsername(proxyOriginal.getUsername());
        if (from instanceof SVNRepositoryLocation && to instanceof SVNRepositoryLocation) {
            SVNRepositoryLocation tmpFrom = (SVNRepositoryLocation)from;
            SVNRepositoryLocation tmpTo = (SVNRepositoryLocation)to;
            tmpTo.repositoryRootUrl = tmpFrom.repositoryRootUrl;
            tmpTo.repositoryUUID = tmpFrom.repositoryUUID;
            tmpTo.getAdditionalRealms().clear();
            Iterator it = from.getRealms().iterator();
            while (it.hasNext()) {
                String realm = (String)it.next();
                IRepositoryLocation target = this.newRepositoryLocation();
                IRepositoryLocation source = from.getLocationForRealm(realm);
                this.copyRepositoryLocation(target, source);
                to.addRealm(realm, target);
            }
        }
    }

    public IRepositoryLocation newRepositoryLocation(String reference) {
        if (reference == null) {
            return this.newRepositoryLocation();
        }
        String[] parts = reference.split(";");
        if (parts.length == 0 || parts[0].length() == 0) {
            return this.newRepositoryLocation();
        }
        IRepositoryLocation location = this.getRepositoryLocation(parts[0]);
        if (location != null) {
            return location;
        }
        String id = parts[0].trim();
        location = new SVNRepositoryLocation(id.length() > 0 ? id : new UniversalUniqueIdentifier().toString());
        location.setUrl("");
        location.setTrunkLocation("");
        location.setTagsLocation("");
        location.setBranchesLocation("");
        switch (parts.length) {
            case 6: {
                location.setTrunkLocation(parts[5].trim());
            }
            case 5: {
                location.setTagsLocation(parts[4].trim());
            }
            case 4: {
                location.setBranchesLocation(parts[3].trim());
            }
            case 3: {
                String label = parts[2].trim();
                if (label.length() > 0) {
                    location.setLabel(label);
                }
            }
            case 2: {
                location.setUrl(parts[1].trim());
            }
        }
        if (location.getLabel() == null || location.getLabel().length() == 0) {
            location.setLabel(location.getUrlAsIs());
        }
        return location;
    }

    public String repositoryLocationAsReference(IRepositoryLocation location) {
        String reference = location.getId();
        reference = String.valueOf(reference) + ";" + location.getUrlAsIs();
        reference = String.valueOf(reference) + ";" + location.getLabel();
        reference = String.valueOf(reference) + ";" + location.getBranchesLocation();
        reference = String.valueOf(reference) + ";" + location.getTagsLocation();
        reference = String.valueOf(reference) + ";" + location.getTrunkLocation();
        return reference;
    }

    public synchronized void addRepositoryLocation(IRepositoryLocation location) {
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
        if (!tmp.contains(location)) {
            tmp.add(location);
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
    }

    public synchronized void removeRepositoryLocation(IRepositoryLocation location) {
        ArrayList<IRepositoryLocation> tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
        if (tmp.remove(location)) {
            this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
        }
    }

    public synchronized void saveConfiguration() throws Exception {
        this.saveLocations();
    }

    public byte[] repositoryResourceAsBytes(IRepositoryResource resource) {
        if (resource == null) {
            return null;
        }
        int selectedKind = resource.getSelectedRevision().getKind();
        int pegKind = resource.getPegRevision().getKind();
        String retVal = String.valueOf(new String(Base64.encode((byte[])String.valueOf(resource instanceof IRepositoryContainer).getBytes()))) + ";" + resource.getRepositoryLocation().getId() + ";" + new String(Base64.encode((byte[])resource.getUrl().getBytes())) + ";" + String.valueOf(selectedKind) + ";" + (selectedKind == 1 ? String.valueOf(((Revision.Number)resource.getSelectedRevision()).getNumber()) : "0") + ";" + String.valueOf(4) + ";" + String.valueOf(pegKind) + ";" + (pegKind == 1 ? String.valueOf(((Revision.Number)resource.getPegRevision()).getNumber()) : "0");
        return retVal.getBytes();
    }

    public IRepositoryResource repositoryResourceFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = false;
        boolean base64Label = false;
        if ("true".equals(data[0])) {
            isFolder = true;
        } else if (!"false".equals(data[0])) {
            isFolder = "true".equals(new String(Base64.decode((byte[])data[0].getBytes())));
            base64Label = true;
        }
        IRepositoryLocation location = this.getRepositoryLocation(data[1]);
        if (location == null) {
            return null;
        }
        int revisionKind = Integer.parseInt(data[3]);
        Revision selectedRevision = revisionKind == 1 ? Revision.getInstance(Long.parseLong(data[4])) : new ISVNStorage.KindBasedRevision(revisionKind);
        Revision pegRevision = null;
        if (data.length > 6) {
            int pegKind = Integer.parseInt(data[6]);
            pegRevision = pegKind == 1 ? Revision.getInstance(Long.parseLong(data[7])) : new ISVNStorage.KindBasedRevision(pegKind);
        }
        String urlPart = base64Label ? new String(Base64.decode((byte[])data[2].getBytes())) : data[2];
        try {
            SVNUtility.getSVNUrl(urlPart);
        }
        catch (MalformedURLException malformedURLException) {
            String prefix = AbstractSVNStorage.getRootPrefix(location, Integer.parseInt(data[5]));
            urlPart = String.valueOf(prefix) + urlPart;
        }
        location = this.wrapLocationIfRequired(location, urlPart, !isFolder);
        IRepositoryResource retVal = isFolder ? location.asRepositoryContainer(urlPart, false) : location.asRepositoryFile(urlPart, false);
        retVal.setSelectedRevision(selectedRevision);
        retVal.setPegRevision(pegRevision);
        return retVal;
    }

    protected abstract IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation var1, String var2, boolean var3);

    protected static String getRootPrefix(IRepositoryLocation location, int rootKind) {
        switch (rootKind) {
            case 4: {
                return location.getRepositoryRootUrl();
            }
            case 0: {
                return location.getUrl();
            }
            case 1: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTrunkLocation() : location.getUrl();
            }
            case 2: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getBranchesLocation() : location.getUrl();
            }
            case 3: {
                return location.isStructureEnabled() ? String.valueOf(location.getUrl()) + "/" + location.getTagsLocation() : location.getUrl();
            }
        }
        return null;
    }

    protected void initializeImpl(IPath stateInfoLocation, String fileName) throws Exception {
        this.stateInfoFile = stateInfoLocation.append(fileName).toFile();
        if (this.stateInfoFile.createNewFile()) {
            this.saveLocations();
        }
        try {
            this.loadLocations();
        }
        catch (Exception ex) {
            LoggedOperation.reportError(SVNTeamPlugin.instance().getResource("Error.LoadLocations"), ex);
            this.saveLocations();
        }
    }

    /*
     * Exception decompiling
     */
    protected void saveLocations() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLocations() throws Exception {
        ArrayList<IRepositoryLocation> tmp;
        block10: {
            tmp = new ArrayList<IRepositoryLocation>(Arrays.asList(this.repositories));
            ObjectInputStream stream = null;
            try {
                try {
                    stream = new ObjectInputStream(new FileInputStream(this.stateInfoFile));
                    while (true) {
                        SVNRepositoryLocation obj;
                        if (tmp.contains(obj = (SVNRepositoryLocation)stream.readObject())) {
                            continue;
                        }
                        tmp.add(obj);
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (stream == null) break block10;
            }
            try {}
            catch (Exception exception) {}
            stream.close();
        }
        this.repositories = tmp.toArray(new IRepositoryLocation[tmp.size()]);
    }
}

