/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import org.eclipse.core.resources.IResource;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.ICommentProvider;
import org.polarion.team.svn.core.resource.IFileChange;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.svnstorage.SVNLocalFile;

public class SVNFileChange
extends SVNLocalFile
implements IFileChange {
    protected Revision pegRevision;
    protected IRepositoryResource originator;
    protected String comment;
    protected ICommentProvider provider;

    public SVNFileChange(IResource resource, long revision, String status, int changeMask, String author, long lastCommitDate, Revision pegRevision, String comment) {
        super(resource, revision, status, changeMask, author, lastCommitDate);
        this.comment = comment;
        this.pegRevision = pegRevision;
    }

    public Revision getPegRevision() {
        return this.pegRevision == null ? (this.revision != -1L ? Revision.getInstance(this.revision) : new ISVNStorage.InvalidRevision()) : this.pegRevision;
    }

    public void setPegRevision(Revision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public IRepositoryResource getOriginator() {
        return this.originator;
    }

    public void setOriginator(IRepositoryResource originator) {
        this.originator = originator;
    }

    public synchronized String getComment() {
        if (this.comment == null && this.provider != null) {
            long rev = this.getRevision();
            this.comment = this.provider.getComment(this.getResource(), rev == -1L ? new ISVNStorage.InvalidRevision() : Revision.getInstance(rev), this.getPegRevision());
            this.provider = null;
        }
        return this.comment;
    }

    public void setCommentProvider(ICommentProvider provider) {
        this.provider = provider;
    }
}

