/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import org.eclipse.core.resources.IResource;
import org.polarion.team.svn.core.resource.ILocalResource;

public abstract class SVNLocalResource
implements ILocalResource {
    protected IResource resource;
    protected long revision;
    protected String status;
    protected int changeMask;
    protected String author;
    protected long lastCommitDate;

    protected SVNLocalResource(IResource resource, long revision, String status, int changeMask, String author, long lastCommitDate) {
        this.resource = resource;
        this.revision = revision;
        this.status = status;
        this.changeMask = changeMask;
        this.author = author != null ? author.intern() : null;
        this.lastCommitDate = lastCommitDate;
    }

    public boolean isLocked() {
        return (this.changeMask & 0x10) != 0;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getName() {
        return this.resource.getName();
    }

    public long getRevision() {
        return this.revision;
    }

    public String getStatus() {
        return this.status;
    }

    public int getChangeMask() {
        return this.changeMask;
    }

    public boolean isCopied() {
        return (this.changeMask & 4) != 0;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getLastCommitDate() {
        return this.lastCommitDate;
    }

    public String toString() {
        return this.resource.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ILocalResource) {
            return this.resource.equals((Object)((ILocalResource)obj).getResource());
        }
        return false;
    }
}

