/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.io.Serializable;
import java.util.Date;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.DirEntry;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SVNRepositoryContainer
extends SVNRepositoryResource
implements IRepositoryContainer,
Serializable {
    private static final long serialVersionUID = -6380931196819185798L;
    protected transient IRepositoryResource[] children;

    protected SVNRepositoryContainer() {
    }

    public SVNRepositoryContainer(IRepositoryLocation location, String url, Revision selectedRevision) {
        super(location, url, selectedRevision);
    }

    public boolean isChildrenCached() {
        return this.children != null;
    }

    public synchronized void refresh() {
        super.refresh();
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRepositoryResource[] getChildren() throws ClientWrapperException {
        SVNRepositoryContainer sVNRepositoryContainer;
        IRepositoryResource[] retVal = this.children;
        if (retVal != null) return retVal;
        String thisUrl = this.getUrl();
        DirEntry[] children = null;
        ISVNClientWrapper proxy = this.getRepositoryLocation().acquireSVNProxy();
        try {
            children = proxy.list(SVNUtility.encodeURL(thisUrl), this.getSelectedRevision(), this.getPegRevision(), false, true, new SVNNullProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            sVNRepositoryContainer = null;
            this.getRepositoryLocation().releaseSVNProxy(proxy);
            sVNRepositoryContainer = this;
        }
        synchronized (sVNRepositoryContainer) {
            retVal = new IRepositoryResource[children.length];
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    this.children = retVal;
                    return retVal;
                }
                String childUrl = String.valueOf(thisUrl) + "/" + children[i].path;
                SVNRepositoryResource resource = children[i].nodeKind == 2 ? (SVNRepositoryResource)((Object)this.asRepositoryContainer(childUrl, false)) : (SVNRepositoryResource)((Object)this.asRepositoryFile(childUrl, false));
                resource.setRevision(children[i].lastChangedRevision);
                resource.setInfo(new IRepositoryResource.Info(children[i].lock, children[i].size, children[i].lastAuthor, children[i].lastChanged, children[i].hasProps));
                retVal[i] = resource;
                ++i;
            }
        }
    }

    protected void getRevisionImpl(ISVNClientWrapper proxy) throws ClientWrapperException {
        String url = SVNUtility.encodeURL(this.getUrl());
        Info2[] infos = proxy.info2(url, this.getSelectedRevision(), this.getPegRevision(), false, new SVNNullProgressMonitor());
        if (infos != null && infos.length > 0 && infos[0].lastChangedRevision != -1L) {
            this.lastRevision = (Revision.Number)Revision.getInstance(infos[0].lastChangedRevision);
            PropertyData[] data = proxy.properties(url, this.getSelectedRevision(), this.getPegRevision(), new SVNNullProgressMonitor());
            this.setInfo(new IRepositoryResource.Info(infos[0].lock, 0L, infos[0].lastChangedAuthor, new Date(infos[0].lastChangedDate), data != null && data.length > 0));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRepositoryContainer)) {
            return false;
        }
        return super.equals(obj);
    }
}

