/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.ICredentialsPrompt;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.options.IOptionProvider;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.ActivityCancelledException;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryBase;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryBranches;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryFile;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryFolder;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocationRoot;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryRoot;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryTags;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryTrunk;
import org.polarion.team.svn.core.utility.ILoggedOperationFactory;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNURLStreamHandler;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SVNRepositoryLocation
extends SVNRepositoryBase
implements IRepositoryLocation,
Serializable {
    private static final int PROXY_CACHE_SIZE = 5;
    private static final long serialVersionUID = -5820937379741639580L;
    public static final int DEFAULT_CONNECTION = 0;
    public static final int SSH_CONNECTION = 1;
    public static final int SSL_CONNECTION = 2;
    public static final int PROXY_CONNECTION = 3;
    protected String id;
    protected String label;
    protected String trunk;
    protected String branches;
    protected String tags;
    protected boolean trunkEnabled;
    protected String username;
    protected String repositoryRootUrl;
    protected String repositoryUUID;
    protected String password;
    protected boolean passwordSaved;
    private transient String passwordTemporary;
    private List serializedRevisionLinks;
    private ProxySettings proxySettings;
    private SSLSettings sslSettings;
    private SSHSettings sshSettings;
    private transient List proxyCache;
    private transient HashSet usedProxies;
    private transient HashMap thread2Proxy;
    private transient IRepositoryResource[] revisionLinks;
    protected transient boolean trustSiteDefined;
    protected transient int trustSite;
    protected transient int proxyConfigurationState;
    protected transient int waiters;
    private Map additionalRealms;

    public SVNRepositoryLocation() {
        super(null);
    }

    public SVNRepositoryLocation(String id) {
        super(null);
        this.id = id;
    }

    public Collection getRealms() {
        return this.getAdditionalRealms().keySet();
    }

    public void addRealm(String realm, IRepositoryLocation location) {
        this.getAdditionalRealms().put(realm, location);
    }

    public void removeRealm(String realm) {
        this.getAdditionalRealms().remove(realm);
    }

    public Collection getRealmLocations() {
        return this.getAdditionalRealms().values();
    }

    public IRepositoryLocation getLocationForRealm(String realm) {
        return (IRepositoryLocation)this.getAdditionalRealms().get(realm);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.getUrl();
    }

    public String getUrlAsIs() {
        return super.getUrl();
    }

    public String getUrl() {
        return this.getUrlImpl(super.getUrl());
    }

    public String getLabel() {
        return this.label == null ? this.getUrl() : this.label;
    }

    public String getRepositoryRootUrl() {
        if (this.repositoryRootUrl == null) {
            if (this.url == null) {
                return null;
            }
            this.fetchRepoInfo();
        }
        return this.repositoryRootUrl == null ? this.getUrl() : this.repositoryRootUrl;
    }

    public String getRepositoryUUID() {
        if (this.repositoryUUID == null) {
            this.fetchRepoInfo();
        }
        return this.repositoryUUID;
    }

    public IRepositoryRoot getRepositoryRoot() {
        return new SVNRepositoryRoot(this);
    }

    public IRepositoryRoot getRoot() {
        return new SVNRepositoryLocationRoot(this);
    }

    public boolean isStructureEnabled() {
        return this.trunkEnabled;
    }

    public void setStructureEnabled(boolean structureEnabled) {
        this.trunkEnabled = structureEnabled;
    }

    public String getUserInputTrunk() {
        return this.trunk == null ? "" : this.trunk;
    }

    public String getUserInputTags() {
        return this.tags == null ? "" : this.tags;
    }

    public String getUserInputBranches() {
        return this.branches == null ? "" : this.branches;
    }

    public String getTrunkLocation() {
        return this.trunk == null || !this.isStructureEnabled() ? "" : this.trunk;
    }

    public String getBranchesLocation() {
        return this.branches == null || !this.isStructureEnabled() ? "" : this.branches;
    }

    public String getTagsLocation() {
        return this.tags == null || !this.isStructureEnabled() ? "" : this.tags;
    }

    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryContainer(this, url, allowsNull);
    }

    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryFile(this, url, allowsNull);
    }

    public static IRepositoryContainer asRepositoryContainer(IRepositoryLocation location, String url, boolean allowsNull) {
        if (!SVNRepositoryLocation.isArgumentsCorrect(location, url, allowsNull)) {
            return null;
        }
        Path urlPath = new Path(url);
        String name = urlPath.lastSegment();
        if (location.isStructureEnabled()) {
            if (name.equals(location.getTrunkLocation())) {
                return new SVNRepositoryTrunk(location, url, Revision.HEAD);
            }
            if (name.equals(location.getTagsLocation())) {
                return new SVNRepositoryTags(location, url, Revision.HEAD);
            }
            if (name.equals(location.getBranchesLocation())) {
                return new SVNRepositoryBranches(location, url, Revision.HEAD);
            }
        }
        if (urlPath.equals((Object)new Path(location.getUrl()))) {
            return location.getRoot();
        }
        if (urlPath.equals((Object)new Path(location.getRepositoryRootUrl()))) {
            return location.getRepositoryRoot();
        }
        return new SVNRepositoryFolder(location, url, Revision.HEAD);
    }

    public static IRepositoryFile asRepositoryFile(IRepositoryLocation location, String url, boolean allowsNull) {
        if (!SVNRepositoryLocation.isArgumentsCorrect(location, url, allowsNull)) {
            return null;
        }
        return new SVNRepositoryFile(location, url, Revision.HEAD);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.passwordSaved ? SVNUtility.base64Decode(this.password) : SVNUtility.base64Decode(this.passwordTemporary);
    }

    public boolean isPasswordSaved() {
        return this.passwordSaved;
    }

    public synchronized IRepositoryResource[] getRevisionLinks() {
        if (this.revisionLinks == null) {
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            List serialized = this.getSerializedRevisionLinks();
            this.revisionLinks = new IRepositoryResource[serialized.size()];
            int i = 0;
            while (i < this.revisionLinks.length) {
                byte[] data = (byte[])serialized.get(i);
                this.revisionLinks[i] = storage.repositoryResourceFromBytes(data);
                ++i;
            }
        }
        return this.revisionLinks;
    }

    public synchronized void addRevisionLink(IRepositoryResource link) {
        IRepositoryResource[] links = this.getRevisionLinks();
        int idx = -1;
        int i = 0;
        while (i < links.length) {
            if (links[i].equals(link) && links[i].getSelectedRevision().equals(link.getSelectedRevision())) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            List serialized = this.getSerializedRevisionLinks();
            serialized.add(SVNRemoteStorage.instance().repositoryResourceAsBytes(link));
            this.revisionLinks = null;
        }
    }

    public synchronized void removeRevisionLink(IRepositoryResource link) {
        IRepositoryResource[] links = this.getRevisionLinks();
        int idx = -1;
        int i = 0;
        while (i < links.length) {
            if (links[i].equals(link) && links[i].getSelectedRevision().equals(link.getSelectedRevision())) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx != -1) {
            List serialized = this.getSerializedRevisionLinks();
            serialized.remove(idx);
            this.revisionLinks = null;
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrl(String url) {
        String oldRootUrl = this.getRepositoryRootUrl();
        IRepositoryResource[] oldLinks = this.getRevisionLinks();
        this.url = url;
        if (oldRootUrl != null && !new Path(oldRootUrl).isPrefixOf((IPath)new Path(this.getUrl()))) {
            this.repositoryRootUrl = null;
            this.repositoryUUID = null;
            if (oldLinks.length > 0) {
                List serialized = this.getSerializedRevisionLinks();
                String newRootUrl = this.getRepositoryRootUrl();
                SVNRemoteStorage storage = SVNRemoteStorage.instance();
                SVNRepositoryLocation sVNRepositoryLocation = this;
                synchronized (sVNRepositoryLocation) {
                    int i = 0;
                    while (i < oldLinks.length) {
                        String linkUrl = oldLinks[i].getUrl();
                        int idx = linkUrl.indexOf(oldRootUrl);
                        if (idx == -1) {
                            serialized.set(i, null);
                        } else {
                            linkUrl = String.valueOf(newRootUrl) + linkUrl.substring(idx + oldRootUrl.length());
                            IRepositoryResource resource = oldLinks[i] instanceof IRepositoryFile ? this.asRepositoryFile(linkUrl, false) : this.asRepositoryContainer(linkUrl, false);
                            resource.setPegRevision(oldLinks[i].getPegRevision());
                            resource.setSelectedRevision(oldLinks[i].getSelectedRevision());
                            serialized.set(i, storage.repositoryResourceAsBytes(resource));
                        }
                        ++i;
                    }
                    Iterator it = serialized.iterator();
                    while (it.hasNext()) {
                        if (it.next() != null) continue;
                        it.remove();
                    }
                    this.revisionLinks = null;
                }
            }
        }
    }

    public void setTrunkLocation(String location) {
        this.trunk = location;
    }

    public void setBranchesLocation(String location) {
        this.branches = location;
    }

    public void setTagsLocation(String location) {
        this.tags = location;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        if (!this.passwordSaved) {
            this.passwordTemporary = SVNUtility.base64Encode(password);
        } else {
            this.password = SVNUtility.base64Encode(password);
        }
    }

    public void setPasswordSaved(boolean saved) {
        if (this.passwordSaved == saved) {
            return;
        }
        this.passwordSaved = saved;
        if (!saved) {
            this.passwordTemporary = this.password;
            this.password = null;
        } else {
            this.password = this.passwordTemporary;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ISVNClientWrapper acquireSVNProxy() {
        ISVNClientWrapper iSVNClientWrapper;
        try {
            try {
                ++this.waiters;
                List cache = this.getProxyCache();
                Thread current = Thread.currentThread();
                ProxyHolder holder = (ProxyHolder)this.thread2Proxy.get(current);
                if (holder != null) {
                    ++holder.referenceCounter;
                    ISVNClientWrapper iSVNClientWrapper2 = holder.proxy;
                    Object var5_8 = null;
                    --this.waiters;
                    return iSVNClientWrapper2;
                }
                if (this.proxyConfigurationState == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.proxyConfigurationState != 2) {
                        throw new ActivityCancelledException(SVNTeamPlugin.instance().getResource("Error.AuthenticationCancelled"));
                    }
                } else if (this.proxyConfigurationState == 0) {
                    this.proxyConfigurationState = 1;
                }
                ISVNClientWrapper retVal = cache.size() == 0 ? this.newProxyInstance() : (ISVNClientWrapper)cache.remove(0);
                this.usedProxies.add(retVal);
                this.thread2Proxy.put(current, new ProxyHolder(retVal));
                iSVNClientWrapper = retVal;
            }
            catch (RuntimeException e) {
                this.proxyConfigurationState = 0;
                this.notifyAll();
                throw e;
            }
            catch (Throwable e) {
                this.proxyConfigurationState = 0;
                this.notifyAll();
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            --this.waiters;
            throw throwable;
        }
        Object var5_9 = null;
        --this.waiters;
        return iSVNClientWrapper;
    }

    public synchronized void releaseSVNProxy(ISVNClientWrapper proxy) {
        List proxies = this.getProxyCache();
        Thread current = Thread.currentThread();
        ProxyHolder holder = (ProxyHolder)this.thread2Proxy.get(current);
        if (--holder.referenceCounter == 0) {
            this.thread2Proxy.remove(current);
            if (!this.usedProxies.remove(proxy) || proxies.size() >= 5) {
                try {
                    proxy.dispose();
                }
                catch (Throwable throwable) {}
            } else {
                proxies.add(proxy);
            }
        } else {
            return;
        }
        if (this.proxyConfigurationState == 1) {
            this.proxyConfigurationState = 2;
        }
        this.notifyAll();
    }

    public synchronized void reconfigure() {
        this.proxyConfigurationState = 0;
        this.reconfigureImpl();
    }

    public synchronized void dispose() {
        this.reconfigureProxies(new IProxyVisitor(){

            public void visit(ISVNClientWrapper proxy) {
                try {
                    proxy.dispose();
                }
                catch (Throwable throwable) {}
            }
        });
        this.getProxyCache().clear();
    }

    public ProxySettings getProxySettings() {
        if (this.proxySettings == null) {
            this.proxySettings = new ProxySettings();
        }
        return this.proxySettings;
    }

    public synchronized SSLSettings getSSLSettings() {
        if (this.sslSettings == null) {
            this.sslSettings = new SSLSettings();
        }
        return this.sslSettings;
    }

    public SSHSettings getSSHSettings() {
        if (this.sshSettings == null) {
            this.sshSettings = new SSHSettings();
        }
        return this.sshSettings;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IRepositoryLocation) {
            IRepositoryLocation other = (IRepositoryLocation)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    protected static boolean isArgumentsCorrect(IRepositoryLocation location, String url, boolean allowsNull) throws IllegalArgumentException {
        Path urlPath;
        if (url == null) {
            throw new IllegalArgumentException(SVNTeamPlugin.instance().getResource("Error.NullURL"));
        }
        Path rootPath = new Path(location.getRepositoryRootUrl());
        if (!rootPath.isPrefixOf((IPath)(urlPath = new Path(url)))) {
            if (!allowsNull) {
                if (!urlPath.isPrefixOf((IPath)rootPath)) {
                    String message = SVNTeamPlugin.instance().getResource("Error.NotRelatedURL");
                    throw new IllegalArgumentException(MessageFormat.format(message, url, rootPath.toString()));
                }
                String message = SVNTeamPlugin.instance().getResource("Error.ShorterURL");
                throw new UnreportableException(MessageFormat.format(message, url, rootPath.toString()));
            }
            return false;
        }
        return true;
    }

    protected void fetchRepoInfo() {
        String[] values = SVNRepositoryLocation.fetchRepoInfo(this, false);
        this.repositoryRootUrl = values[0];
        this.repositoryUUID = values[1];
    }

    public static String[] fetchRepoInfo(final IRepositoryLocation location, final boolean usePrompt) {
        final String[] retVal = new String[2];
        ProgressMonitorUtility.doTaskExternal(new AbstractNonLockingOperation("Operation.FetchRepositoryRoot"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ISVNClientWrapper proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
                proxy.setCredentialsCacheEnabled(false);
                SVNUtility.configureProxy(proxy, location);
                if (usePrompt) {
                    IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
                    ICredentialsPrompt externalPrompt = optionProvider.getCredentialsPrompt();
                    if (externalPrompt != null) {
                        proxy.setPrompt(new BaseCredentialsPromptWrapper(externalPrompt, location));
                    }
                } else {
                    proxy.setPrompt(new BaseCredentialsPromptWrapper(null, location));
                }
                Info2[] infos = null;
                String url = location.getUrl();
                try {
                    infos = proxy.info2(SVNUtility.encodeURL(url), Revision.HEAD, Revision.HEAD, false, new SVNProgressMonitor(this, monitor, null));
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    proxy.dispose();
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    proxy.dispose();
                }
                if (infos != null && infos.length > 0 && infos[0] != null) {
                    retVal[0] = SVNUtility.decodeURL(infos[0].reposRootUrl);
                    if (!new Path(retVal[0]).isPrefixOf((IPath)new Path(url))) {
                        SVNURLStreamHandler userUrl = SVNUtility.getSVNUrlStreamHandler(url);
                        SVNURLStreamHandler returnedURL = SVNUtility.getSVNUrlStreamHandler(retVal[0]);
                        returnedURL.setHost(userUrl.getURL().getHost());
                        retVal[0] = returnedURL.getURL().toExternalForm();
                    }
                    retVal[1] = infos[0].reposUUID;
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor(), new ILoggedOperationFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                return operation;
            }
        });
        return retVal;
    }

    protected void reconfigureImpl() {
        final IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
        this.reconfigureProxies(new IProxyVisitor(){

            public void visit(ISVNClientWrapper proxy) {
                SVNRepositoryLocation.this.configureProxy(proxy, optionProvider);
            }
        });
    }

    protected void reconfigureProxies(IProxyVisitor visitor) {
        this.visitProxies(visitor);
        this.usedProxies.clear();
    }

    protected void visitProxies(IProxyVisitor visitor) {
        Iterator it = this.getProxyCache().iterator();
        while (it.hasNext()) {
            ISVNClientWrapper proxy = (ISVNClientWrapper)it.next();
            visitor.visit(proxy);
        }
    }

    protected List getProxyCache() {
        if (this.proxyCache == null) {
            this.proxyCache = new ArrayList();
            this.usedProxies = new HashSet();
            this.thread2Proxy = new HashMap();
        }
        return this.proxyCache;
    }

    protected ISVNClientWrapper newProxyInstance() {
        IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
        ISVNClientWrapper proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
        proxy.setCredentialsCacheEnabled(false);
        proxy.setSSLCertificateCacheEnabled(true);
        proxy.setTouchUnresolved(false);
        proxy.setCommitMissingFiles(true);
        this.configureProxy(proxy, optionProvider);
        ICredentialsPrompt externalPrompt = optionProvider.getCredentialsPrompt();
        if (externalPrompt != null) {
            proxy.setPrompt(new CredentialsPromptWrapper(externalPrompt));
        }
        return proxy;
    }

    protected List getSerializedRevisionLinks() {
        if (this.serializedRevisionLinks == null) {
            this.serializedRevisionLinks = new ArrayList();
        }
        return this.serializedRevisionLinks;
    }

    protected void configureProxy(ISVNClientWrapper proxy, IOptionProvider optionProvider) {
        SVNUtility.configureProxy(proxy, this);
        proxy.setReportRevisionChange(optionProvider.getReportRevisionChange());
    }

    protected String getUrlImpl(String url) {
        if (url == null) {
            return null;
        }
        try {
            url = SVNUtility.decodeURL(url);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return SVNUtility.normalizeURL(url);
    }

    protected synchronized Map getAdditionalRealms() {
        if (this.additionalRealms == null) {
            this.additionalRealms = new LinkedHashMap();
        }
        return this.additionalRealms;
    }

    protected static interface IProxyVisitor {
        public void visit(ISVNClientWrapper var1);
    }

    public static class BaseCredentialsPromptWrapper
    implements ICredentialsPrompt {
        protected ICredentialsPrompt prompt;
        protected String tryRealm;
        protected String threadName;
        protected static final int MAX_ACCESS_COUNT = 5;
        protected int accessCount;
        protected IRepositoryLocation realmLocation;
        protected IRepositoryLocation location;

        public BaseCredentialsPromptWrapper(ICredentialsPrompt prompt, IRepositoryLocation location) {
            this.prompt = prompt == null ? ICredentialsPrompt.DEFAULT_PROMPT : prompt;
            this.location = location;
        }

        public int askTrustSSLServer(IRepositoryLocation location, String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(this.location, info, allowPermanently);
        }

        public String getRealmToSave() {
            return this.prompt.getRealmToSave();
        }

        public String getProxyHost() {
            return this.prompt.getProxyHost();
        }

        public String getProxyPassword() {
            return this.prompt.getProxyPassword();
        }

        public int getProxyPort() {
            return this.prompt.getProxyPort();
        }

        public String getProxyUserName() {
            return this.prompt.getProxyUserName();
        }

        public int getSSHPort() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPort() : this.prompt.getSSHPort();
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPassPhrase() : this.prompt.getSSHPrivateKeyPassphrase();
        }

        public String getSSHPrivateKeyPath() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPrivateKeyPath() : this.prompt.getSSHPrivateKeyPath();
        }

        public String getSSLClientCertPassword() {
            return this.realmLocation != null ? this.realmLocation.getSSLSettings().getPassPhrase() : this.prompt.getSSLClientCertPassword();
        }

        public String getSSLClientCertPath() {
            return this.realmLocation != null ? this.realmLocation.getSSLSettings().getCertificatePath() : this.prompt.getSSLClientCertPath();
        }

        public String getUsername() {
            return this.realmLocation != null ? this.realmLocation.getUsername() : this.prompt.getUsername();
        }

        public String getPassword() {
            return this.realmLocation != null ? this.realmLocation.getPassword() : this.prompt.getPassword();
        }

        public boolean isProxyAuthenticationEnabled() {
            return this.prompt.isProxyAuthenticationEnabled();
        }

        public boolean isProxyEnabled() {
            return this.prompt.isProxyEnabled();
        }

        public boolean isSSHPrivateKeyPassphraseSaved() {
            return this.prompt.isSSHPrivateKeyPassphraseSaved();
        }

        public boolean isSSHPublicKeySelected() {
            return this.prompt.isSSHPublicKeySelected();
        }

        public boolean isSSLAuthenticationEnabled() {
            return this.prompt.isSSLAuthenticationEnabled();
        }

        public boolean isSSLSavePassphrase() {
            return this.prompt.isSSLSavePassphrase();
        }

        public boolean isSaveCredentialsEnabled() {
            return this.prompt.isSaveCredentialsEnabled();
        }

        public boolean isSaveProxyPassword() {
            return this.prompt.isSaveProxyPassword();
        }

        public boolean promptProxy(IRepositoryLocation location) {
            boolean retVal = this.prompt.promptProxy(this.location);
            this.checkForSave(retVal, 3);
            return retVal;
        }

        public boolean prompt(IRepositoryLocation location, String realm) {
            if (this.tryCachedRealm(realm) && this.realmLocation.getUsername() != null && this.realmLocation.getPassword() != null) {
                return true;
            }
            boolean retVal = this.prompt.prompt(this.location, realm);
            this.checkForSave(retVal, 0);
            return retVal;
        }

        public boolean promptSSH(IRepositoryLocation location, String realm) {
            SSHSettings sshSettings;
            if (this.tryCachedRealm(realm) && ((sshSettings = this.realmLocation.getSSHSettings()).isUseKeyFile() && sshSettings.getPrivateKeyPath() != null || !sshSettings.isUseKeyFile() && this.realmLocation.getUsername() != null && this.realmLocation.getPassword() != null)) {
                return true;
            }
            boolean retVal = this.prompt.promptSSH(this.location, realm);
            this.checkForSave(retVal, 1);
            return retVal;
        }

        public boolean promptSSL(IRepositoryLocation location, String realm) {
            if (this.tryCachedRealm(realm) && this.realmLocation.getSSLSettings().getCertificatePath() != null) {
                return true;
            }
            boolean retVal = this.prompt.promptSSL(this.location, realm);
            this.checkForSave(retVal, 2);
            return retVal;
        }

        protected boolean tryCachedRealm(String realm) {
            String threadName = Thread.currentThread().getName();
            if (!CoreExtensionsManager.instance().getSVNClientWrapperFactory().getId().equals("org.polarion.team.svn.client.javahl")) {
                if (this.tryRealm == null || !this.tryRealm.equals(realm) || !threadName.equals(this.threadName) || this.accessCount < 5) {
                    this.realmLocation = this.location.getLocationForRealm(realm);
                    if (this.realmLocation != null) {
                        this.accessCount = threadName.equals(this.threadName) && this.tryRealm.equals(realm) ? ++this.accessCount : 0;
                        this.tryRealm = realm;
                        this.threadName = threadName;
                        return true;
                    }
                } else {
                    this.tryRealm = null;
                    this.realmLocation = null;
                    this.threadName = null;
                    this.accessCount = 0;
                }
            }
            return false;
        }

        protected void checkForSave(boolean retVal, int connectionType) {
            if (retVal) {
                IRepositoryLocation location = this.location;
                String realmToSave = this.getRealmToSave();
                if (!"<Repository Location>".equals(realmToSave) && (location = this.location.getLocationForRealm(realmToSave)) == null) {
                    location = SVNRemoteStorage.instance().newRepositoryLocation();
                    SVNRemoteStorage.instance().copyRepositoryLocation(location, this.location);
                    this.location.addRealm(realmToSave, location);
                }
                this.checkForSaveImpl(location, retVal, connectionType);
                try {
                    SVNRemoteStorage.instance().saveConfiguration();
                }
                catch (Exception exception) {}
            }
        }

        protected void checkForSaveImpl(IRepositoryLocation location, boolean retVal, int connectionType) {
            if (connectionType == 3) {
                ProxySettings settings = location.getProxySettings();
                settings.setEnabled(this.prompt.isProxyEnabled());
                if (settings.isEnabled()) {
                    settings.setHost(this.prompt.getProxyHost());
                    settings.setPort(this.prompt.getProxyPort());
                    settings.setAuthenticationEnabled(this.prompt.isProxyAuthenticationEnabled());
                    if (settings.isAuthenticationEnabled()) {
                        settings.setUsername(this.prompt.getProxyUserName());
                        settings.setPassword(this.prompt.getProxyPassword());
                        settings.setPasswordSaved(this.prompt.isSaveProxyPassword());
                    }
                }
            } else {
                Serializable settings;
                location.setUsername(this.prompt.getUsername());
                location.setPassword(this.prompt.getPassword());
                location.setPasswordSaved(this.prompt.isSaveCredentialsEnabled());
                if (connectionType == 1) {
                    settings = location.getSSHSettings();
                    ((SSHSettings)settings).setUseKeyFile(this.prompt.isSSHPublicKeySelected());
                    if (((SSHSettings)settings).isUseKeyFile()) {
                        ((SSHSettings)settings).setPrivateKeyPath(this.prompt.getSSHPrivateKeyPath());
                        ((SSHSettings)settings).setPassPhraseSaved(this.prompt.isSSHPrivateKeyPassphraseSaved());
                        ((SSHSettings)settings).setPassPhrase(this.getSSHPrivateKeyPassphrase());
                    }
                }
                if (connectionType == 2) {
                    settings = location.getSSLSettings();
                    ((SSLSettings)settings).setAuthenticationEnabled(this.prompt.isSSLAuthenticationEnabled());
                    if (((SSLSettings)settings).isAuthenticationEnabled()) {
                        ((SSLSettings)settings).setCertificatePath(this.prompt.getSSLClientCertPath());
                        ((SSLSettings)settings).setPassPhrase(this.prompt.getSSLClientCertPassword());
                        ((SSLSettings)settings).setPassPhraseSaved(this.prompt.isSSLSavePassphrase());
                    }
                }
            }
        }
    }

    protected class CredentialsPromptWrapper
    extends BaseCredentialsPromptWrapper {
        public CredentialsPromptWrapper(ICredentialsPrompt prompt) {
            super(prompt, SVNRepositoryLocation.this);
        }

        public int askTrustSSLServer(IRepositoryLocation location, String info, boolean allowPermanently) {
            if (!SVNRepositoryLocation.this.trustSiteDefined) {
                SVNRepositoryLocation.this.trustSite = super.askTrustSSLServer(SVNRepositoryLocation.this, info, allowPermanently);
                if (SVNRepositoryLocation.this.trustSite != 0) {
                    SVNRepositoryLocation.this.trustSiteDefined = true;
                } else {
                    SVNRepositoryLocation.this.proxyConfigurationState = 0;
                }
                return SVNRepositoryLocation.this.trustSite;
            }
            return SVNRepositoryLocation.this.trustSite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkForSave(boolean retVal, int connectionType) {
            SVNRepositoryLocation sVNRepositoryLocation = SVNRepositoryLocation.this;
            synchronized (sVNRepositoryLocation) {
                if (retVal) {
                    super.checkForSave(retVal, connectionType);
                } else {
                    SVNRepositoryLocation.this.proxyConfigurationState = 0;
                }
                SVNRepositoryLocation.this.reconfigureImpl();
            }
        }
    }

    protected static class ProxyHolder {
        public final ISVNClientWrapper proxy;
        public int referenceCounter;

        public ProxyHolder(ISVNClientWrapper proxy) {
            this.proxy = proxy;
            this.referenceCounter = 1;
        }
    }
}

