/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.util.Collection;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocationRoot;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryRoot;

public class SVNRepositoryLocationWrapper
implements IRepositoryLocation {
    protected IRepositoryLocation location;
    protected String url;
    protected String repositoryRootUrl;
    protected String repositoryUUID;

    public SVNRepositoryLocationWrapper(IRepositoryLocation location, String mappedUrl) {
        this.location = location;
        this.url = mappedUrl;
    }

    public String getUrlAsIs() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryContainer(this, url, allowsNull);
    }

    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryFile(this, url, allowsNull);
    }

    public IRepositoryRoot getRepositoryRoot() {
        return new SVNRepositoryRoot(this);
    }

    public IRepositoryRoot getRoot() {
        return new SVNRepositoryLocationRoot(this);
    }

    public String getRepositoryRootUrl() {
        if (this.repositoryRootUrl == null) {
            this.fetchRepoInfo();
        }
        return this.repositoryRootUrl == null ? this.getUrl() : this.repositoryRootUrl;
    }

    public String getRepositoryUUID() {
        if (this.repositoryUUID == null) {
            this.fetchRepoInfo();
        }
        return this.repositoryUUID;
    }

    public ISVNClientWrapper acquireSVNProxy() {
        return this.location.acquireSVNProxy();
    }

    public void addRealm(String realm, IRepositoryLocation location) {
        this.location.addRealm(realm, location);
    }

    public void addRevisionLink(IRepositoryResource link) {
        this.location.addRevisionLink(link);
    }

    public void dispose() {
        this.location.dispose();
    }

    public String getBranchesLocation() {
        return this.location.getBranchesLocation();
    }

    public String getId() {
        return this.location.getId();
    }

    public String getLabel() {
        return this.location.getLabel();
    }

    public IRepositoryLocation getLocationForRealm(String realm) {
        return this.location.getLocationForRealm(realm);
    }

    public String getPassword() {
        return this.location.getPassword();
    }

    public ProxySettings getProxySettings() {
        return this.location.getProxySettings();
    }

    public Collection getRealmLocations() {
        return this.location.getRealmLocations();
    }

    public Collection getRealms() {
        return this.location.getRealms();
    }

    public IRepositoryResource[] getRevisionLinks() {
        return this.location.getRevisionLinks();
    }

    public SSHSettings getSSHSettings() {
        return this.location.getSSHSettings();
    }

    public SSLSettings getSSLSettings() {
        return this.location.getSSLSettings();
    }

    public String getTagsLocation() {
        return this.location.getTagsLocation();
    }

    public String getTrunkLocation() {
        return this.location.getTrunkLocation();
    }

    public String getUserInputBranches() {
        return this.location.getUserInputBranches();
    }

    public String getUserInputTags() {
        return this.location.getUserInputTags();
    }

    public String getUserInputTrunk() {
        return this.location.getUserInputTrunk();
    }

    public String getUsername() {
        return this.location.getUsername();
    }

    public boolean isPasswordSaved() {
        return this.location.isPasswordSaved();
    }

    public boolean isStructureEnabled() {
        return this.location.isStructureEnabled();
    }

    public void reconfigure() {
        this.location.reconfigure();
    }

    public void releaseSVNProxy(ISVNClientWrapper proxy) {
        this.location.releaseSVNProxy(proxy);
    }

    public void removeRealm(String realm) {
        this.location.removeRealm(realm);
    }

    public void removeRevisionLink(IRepositoryResource link) {
        this.location.removeRevisionLink(link);
    }

    public void setBranchesLocation(String location) {
        this.location.setBranchesLocation(location);
    }

    public void setLabel(String label) {
        this.location.setLabel(label);
    }

    public void setPassword(String password) {
        this.location.setPassword(password);
    }

    public void setPasswordSaved(boolean saved) {
        this.location.setPasswordSaved(saved);
    }

    public void setStructureEnabled(boolean enabled) {
        this.location.setStructureEnabled(enabled);
    }

    public void setTagsLocation(String location) {
        this.location.setTagsLocation(location);
    }

    public void setTrunkLocation(String location) {
        this.location.setTrunkLocation(location);
    }

    public void setUsername(String username) {
        this.location.setUsername(username);
    }

    public String getName() {
        return this.location.getName();
    }

    public Object getAdapter(Class adapter) {
        return this.location.getAdapter(adapter);
    }

    protected void fetchRepoInfo() {
        String[] values = SVNRepositoryLocation.fetchRepoInfo(this, true);
        this.repositoryRootUrl = values[0];
        this.repositoryUUID = values[1];
    }
}

