/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.utility;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.Team;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.options.IIgnoreRecommendations;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.operation.file.SVNFileStorage;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.Notify2Composite;
import org.polarion.team.svn.core.utility.PatternProvider;
import org.polarion.team.svn.core.utility.RepositoryLocationUtility;
import org.polarion.team.svn.core.utility.SVNURLStreamHandler;

public final class SVNUtility {
    private static String svnFolderName = null;

    public static String getStatusText(String status) {
        if (status == null) {
            status = "NotExists";
        }
        return SVNTeamPlugin.instance().getResource("Status." + status);
    }

    public static String getOldRoot(String oldUrl, IRepositoryResource[] rootChildren) {
        int i = 0;
        while (i < rootChildren.length) {
            String childName = rootChildren[i].getName();
            int idx = oldUrl.indexOf(childName);
            if (idx > 0 && oldUrl.charAt(idx - 1) == '/' && (oldUrl.endsWith(childName) || oldUrl.charAt(idx + childName.length()) == '/')) {
                return oldUrl.substring(0, idx - 1);
            }
            ++i;
        }
        return null;
    }

    public static IRepositoryRoot getTrunkLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTrunkLocation());
    }

    public static IRepositoryRoot getBranchesLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getBranchesLocation());
    }

    public static IRepositoryRoot getTagsLocation(IRepositoryResource resource) {
        return SVNUtility.getRootLocation(resource, resource.getRepositoryLocation().getTagsLocation());
    }

    public static IRepositoryContainer getProposedTrunk(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTrunkLocation(location), false);
    }

    public static IRepositoryContainer getProposedBranches(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedBranchesLocation(location), false);
    }

    public static IRepositoryContainer getProposedTags(IRepositoryLocation location) {
        return location.asRepositoryContainer(SVNUtility.getProposedTagsLocation(location), false);
    }

    public static String getProposedTrunkLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getTrunkLocation() : baseUrl;
    }

    public static String getProposedBranchesLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getBranchesLocation() : baseUrl;
    }

    public static String getProposedTagsLocation(IRepositoryLocation location) {
        String baseUrl = location.getUrl();
        return location.isStructureEnabled() ? String.valueOf(baseUrl) + "/" + location.getTagsLocation() : baseUrl;
    }

    public static IRepositoryRoot[] findRoots(String resourceUrl, boolean longestOnly) {
        Path url = new Path(resourceUrl);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation[] locations = storage.getRepositoryLocations();
        ArrayList roots = new ArrayList();
        int i = 0;
        while (i < locations.length) {
            if (new Path(locations[i].getUrl()).isPrefixOf((IPath)url) && new Path(locations[i].getRepositoryRootUrl()).isPrefixOf((IPath)url)) {
                SVNUtility.addRepositoryRoot(roots, (IRepositoryRoot)locations[i].asRepositoryContainer(resourceUrl, false).getRoot(), longestOnly);
            }
            ++i;
        }
        Object[] repositoryRoots = roots.toArray(new IRepositoryRoot[roots.size()]);
        if (!longestOnly) {
            FileUtility.sort(repositoryRoots, new Comparator(){

                public int compare(Object o1, Object o2) {
                    IRepositoryRoot first = (IRepositoryRoot)o1;
                    IRepositoryRoot second = (IRepositoryRoot)o2;
                    return second.getUrl().compareTo(first.getUrl());
                }
            });
        }
        return repositoryRoots;
    }

    private static void addRepositoryRoot(List container, IRepositoryRoot root, boolean longestOnly) {
        if (longestOnly && container.size() > 0) {
            int cnt2;
            int cnt = new Path(root.getUrl()).segmentCount();
            if (cnt > (cnt2 = new Path(((IRepositoryRoot)container.get(0)).getUrl()).segmentCount())) {
                container.clear();
                container.add(root);
            } else if (cnt == cnt2) {
                container.add(root);
            }
        } else {
            container.add(root);
        }
    }

    public static synchronized String getSVNFolderName() {
        if (svnFolderName == null) {
            String name = FileUtility.getEnvironmentVariables().get("SVN_ASP_DOT_NET_HACK") != null ? "_svn" : ".svn";
            svnFolderName = System.getProperty("javasvn.admindir", name);
        }
        return svnFolderName;
    }

    public static String getResourceParent(IRepositoryResource resource) {
        String rootUrl;
        String parent = "";
        String url = resource.getUrl();
        if (url.equals(rootUrl = resource.getRoot().getUrl())) {
            return "";
        }
        parent = url.substring(rootUrl.length(), url.length() - resource.getName().length() - 1);
        return parent;
    }

    public static IRepositoryResource copyOf(IRepositoryResource resource) {
        String url = resource.getUrl();
        return resource instanceof IRepositoryFile ? resource.asRepositoryFile(url, false) : resource.asRepositoryContainer(url, false);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, String relativeReference, boolean isFile) {
        String url = SVNUtility.normalizeURL(String.valueOf(upPoint.getUrl()) + "/" + relativeReference);
        IRepositoryLocation location = upPoint.getRepositoryLocation();
        IRepositoryResource downPoint = isFile ? location.asRepositoryFile(url, false) : location.asRepositoryContainer(url, false);
        downPoint.setPegRevision(upPoint.getPegRevision());
        downPoint.setSelectedRevision(upPoint.getSelectedRevision());
        return SVNUtility.makeResourceSet(upPoint, downPoint);
    }

    public static IRepositoryResource[] makeResourceSet(IRepositoryResource upPoint, IRepositoryResource downPoint) {
        ArrayList<IRepositoryResource> resourceSet = new ArrayList<IRepositoryResource>();
        while (downPoint != null && !downPoint.equals(upPoint)) {
            resourceSet.add(0, downPoint);
            downPoint = downPoint.getParent();
        }
        return resourceSet.toArray(new IRepositoryResource[resourceSet.size()]);
    }

    public static URL getSVNUrl(String url) throws MalformedURLException {
        return SVNUtility.getSVNUrlStreamHandler(url).getURL();
    }

    public static SVNURLStreamHandler getSVNUrlStreamHandler(String url) throws MalformedURLException {
        SVNURLStreamHandler retVal = new SVNURLStreamHandler();
        new URL(null, url, retVal);
        return retVal;
    }

    public static String base64Encode(String data) {
        if (data == null) {
            return null;
        }
        return new String(Base64.encode((byte[])data.getBytes()));
    }

    public static String base64Decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        return new String(Base64.decode((byte[])encoded.getBytes()));
    }

    public static synchronized void addSVNNotifyListener(ISVNClientWrapper proxy, Notify2 listener) {
        Notify2Composite composite = (Notify2Composite)proxy.getNotification2();
        if (composite == null) {
            composite = new Notify2Composite();
            proxy.notification2(composite);
        }
        composite.add(listener);
    }

    public static synchronized void removeSVNNotifyListener(ISVNClientWrapper proxy, Notify2 listener) {
        Notify2Composite composite = (Notify2Composite)proxy.getNotification2();
        if (composite != null) {
            composite.remove(listener);
        }
    }

    public static void reorder(Status[] statuses, final boolean parent2Child) {
        FileUtility.sort(statuses, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((Status)o1).path;
                String s2 = ((Status)o2).path;
                return parent2Child ? s1.compareTo(s2) : s2.compareTo(s1);
            }

            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    public static String encodeURL(String url) {
        try {
            url = SVNUtility.normalizeURL(url);
            if (url.startsWith("file:")) {
                return url;
            }
            int idx = url.indexOf("://");
            if ((idx = url.indexOf("/", idx + 3)) == -1) {
                return url;
            }
            String retVal = url.substring(0, idx);
            StringTokenizer tok = new StringTokenizer(url.substring(idx), "/ ", true);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                retVal = token.equals("/") ? String.valueOf(retVal) + token : (token.equals(" ") ? String.valueOf(retVal) + "%20" : String.valueOf(retVal) + URLEncoder.encode(token, "UTF-8"));
            }
            return retVal;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decodeURL(String url) {
        try {
            url = SVNUtility.normalizeURL(url);
            if (url.startsWith("file:")) {
                return url;
            }
            int idx = url.indexOf("://");
            if ((idx = url.indexOf("/", idx + 3)) == -1) {
                return url;
            }
            String retVal = url.substring(0, idx);
            StringTokenizer tok = new StringTokenizer(url.substring(idx), "/+", true);
            idx = retVal.indexOf(64);
            if (idx != -1) {
                String protocol = retVal.substring(0, retVal.indexOf("://") + 3);
                String serverPart = retVal.substring(idx);
                retVal = String.valueOf(protocol) + URLDecoder.decode(retVal.substring(protocol.length(), idx), "UTF-8") + serverPart;
            }
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                retVal = token.equals("/") || token.equals("+") ? String.valueOf(retVal) + token : String.valueOf(retVal) + URLDecoder.decode(token, "UTF-8");
            }
            return retVal;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String normalizeURL(String url) {
        StringTokenizer tokenizer = new StringTokenizer(PatternProvider.replaceAll(url, "([\\\\])+", "/"), "/", false);
        String retVal = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            retVal = String.valueOf(retVal) + (retVal.length() == 0 ? token : "/" + token);
        }
        int idx = retVal.indexOf(58) + 1;
        return idx == 0 ? retVal : String.valueOf(retVal.substring(0, idx)) + (url.startsWith("file:///") ? "//" : "/") + retVal.substring(idx);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Exception validateRepositoryLocation(IRepositoryLocation location) {
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            try {
                proxy.list(SVNUtility.encodeURL(location.getUrl()), Revision.HEAD, Revision.HEAD, false, false, new SVNNullProgressMonitor());
            }
            catch (Exception e) {
                Exception exception = e;
                Object var3_4 = null;
                location.releaseSVNProxy(proxy);
                location.dispose();
                return exception;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            location.releaseSVNProxy(proxy);
            location.dispose();
            throw throwable;
        }
        {
            Object var3_6 = null;
            location.releaseSVNProxy(proxy);
            location.dispose();
            return null;
        }
    }

    public static void configureProxy(ISVNClientWrapper proxy, IRepositoryLocation location) {
        proxy.username(location.getUsername());
        proxy.password(location.getPassword());
        ProxySettings proxySettings = location.getProxySettings();
        if (proxySettings.isEnabled()) {
            proxy.setProxy(proxySettings.getHost(), proxySettings.getPort(), proxySettings.isAuthenticationEnabled() ? proxySettings.getUsername() : "", proxySettings.isAuthenticationEnabled() ? proxySettings.getPassword() : "");
        } else {
            proxy.setProxy(null, -1, null, null);
        }
        SSLSettings sslSettings = location.getSSLSettings();
        if (sslSettings.isAuthenticationEnabled()) {
            proxy.setClientSSLCertificate(sslSettings.getCertificatePath(), sslSettings.getPassPhrase());
        } else {
            proxy.setClientSSLCertificate(null, null);
        }
        SSHSettings sshSettings = location.getSSHSettings();
        if (!sshSettings.isUseKeyFile()) {
            proxy.setSSHCredentials(location.getUsername(), location.getPassword(), sshSettings.getPort());
        } else if (sshSettings.getPrivateKeyPath().length() > 0) {
            proxy.setSSHCredentials(location.getUsername(), sshSettings.getPrivateKeyPath(), sshSettings.getPassPhrase(), sshSettings.getPort());
        } else {
            proxy.setSSHCredentials(null, null, null, -1);
        }
    }

    public static Status getSVNInfoForNotConnected(IResource root) {
        ISVNClientWrapper proxy;
        block8: {
            IPath checkedPath;
            IPath location = root.getLocation();
            if (location == null) {
                return null;
            }
            IPath iPath = checkedPath = root.getType() == 1 ? location.removeLastSegments(1) : location;
            if (!checkedPath.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
                return null;
            }
            proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
            Status[] st = proxy.status(location.toString(), false, false, true, false, new SVNNullProgressMonitor());
            if (st == null || st.length <= 0) break block8;
            SVNUtility.reorder(st, true);
            Status status = st[0].url == null ? null : st[0];
            Object var5_6 = null;
            proxy.dispose();
            return status;
        }
        while (true) {
            try {
                Object var5_7 = null;
                proxy.dispose();
                return null;
            }
            catch (Exception exception) {
                try {
                    continue;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    proxy.dispose();
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIgnored(IResource resource) {
        if (resource instanceof IWorkspaceRoot) return true;
        if (resource.isDerived()) return true;
        if (FileUtility.isSVNInternals(resource)) return true;
        if (Team.isIgnoredHint((IResource)resource)) return true;
        if (SVNUtility.isMergeParts(resource)) {
            return true;
        }
        try {
            IIgnoreRecommendations[] ignores = CoreExtensionsManager.instance().getIgnoreRecommendations();
            int i = 0;
            while (true) {
                if (i >= ignores.length) {
                    return false;
                }
                if (ignores[i].isAcceptableNature(resource) && ignores[i].isIgnoreRecommended(resource)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static Map splitWorkingCopies(IResource[] resources) {
        HashMap<IProject, ArrayList<IResource>> wc2Resources = new HashMap<IProject, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            IProject wcRoot = resources[i].getProject();
            ArrayList<IResource> wcResources = (ArrayList<IResource>)wc2Resources.get(wcRoot);
            if (wcResources == null) {
                wcResources = new ArrayList<IResource>();
                wc2Resources.put(wcRoot, wcResources);
            }
            wcResources.add(resources[i]);
            ++i;
        }
        return wc2Resources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map splitWorkingCopies(File[] files) {
        HashMap wc2Resources = new HashMap();
        ISVNClientWrapper proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
        try {
            ArrayList<File> restOfFiles;
            HashMap<File, Info2> file2info = new HashMap<File, Info2>();
            int i = 0;
            while (true) {
                if (i >= files.length) {
                    restOfFiles = new ArrayList<File>(Arrays.asList(files));
                    break;
                }
                file2info.put(files[i], SVNUtility.getSVNInfo(files[i], proxy));
                ++i;
            }
            while (restOfFiles.size() > 0) {
                Info2 info;
                File current = restOfFiles.get(0);
                Object[] wcRoot = SVNUtility.getWCRoot(proxy, current, info = (Info2)file2info.get(current));
                ArrayList<File> wcResources = (ArrayList<File>)wc2Resources.get(wcRoot[0]);
                if (wcResources == null) {
                    wcResources = new ArrayList<File>();
                    wc2Resources.put(wcRoot[0], wcResources);
                }
                Path rootPath = new Path(((File)wcRoot[0]).getAbsolutePath());
                Path rootInfoPath = new Path(((Info2)wcRoot[1]).url);
                Iterator<File> it = restOfFiles.iterator();
                while (it.hasNext()) {
                    File checked = it.next();
                    if (!rootPath.isPrefixOf((IPath)new Path(checked.getAbsolutePath()))) continue;
                    Info2 checkedInfo = (Info2)file2info.get(checked);
                    if (!rootInfoPath.isPrefixOf((IPath)new Path(checkedInfo.url))) continue;
                    wcResources.add(checked);
                    it.remove();
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            proxy.dispose();
            throw throwable;
        }
        {
            Object var14_17 = null;
            proxy.dispose();
            return wc2Resources;
        }
    }

    private static Object[] getWCRoot(ISVNClientWrapper proxy, File node, Info2 info) {
        File oldRoot = node;
        Info2 oldInfo = info;
        node = node.getParentFile();
        while (node != null) {
            Info2 rootInfo = SVNUtility.getSVNInfo(node, proxy);
            if (rootInfo != null) {
                if (oldInfo == null) {
                    oldInfo = rootInfo;
                } else if (!new Path(rootInfo.url).isPrefixOf((IPath)new Path(oldInfo.url))) {
                    return new Object[]{oldRoot, oldInfo};
                }
                oldRoot = node;
                node = node.getParentFile();
                continue;
            }
            if (oldInfo == null) continue;
            return new Object[]{oldRoot, oldInfo};
        }
        if (oldInfo == null) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.NonSVNPath");
            throw new RuntimeException(MessageFormat.format(errMessage, node.getAbsolutePath()));
        }
        return new Object[]{oldRoot, oldInfo};
    }

    public static Info2 getSVNInfo(File root) {
        ISVNClientWrapper proxy = CoreExtensionsManager.instance().getSVNClientWrapperFactory().newInstance();
        try {
            Info2 info2 = SVNUtility.getSVNInfo(root, proxy);
            Object var2_3 = null;
            proxy.dispose();
            return info2;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            proxy.dispose();
            throw throwable;
        }
    }

    public static Info2 getSVNInfo(File root, ISVNClientWrapper proxy) {
        if (root.exists()) {
            File svnMeta = root.isDirectory() ? root : root.getParentFile();
            if ((svnMeta = new File(String.valueOf(svnMeta.getAbsolutePath()) + "/" + SVNUtility.getSVNFolderName())).exists()) {
                try {
                    Info2[] st = proxy.info2(root.getAbsolutePath(), Revision.BASE, null, false, new SVNNullProgressMonitor());
                    return st != null && st.length != 0 ? st[0] : null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return null;
    }

    public static String[] asURLArray(IRepositoryResource[] resources, boolean encode) {
        String[] retVal = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            retVal[i] = encode ? SVNUtility.encodeURL(resources[i].getUrl()) : resources[i].getUrl();
            ++i;
        }
        return retVal;
    }

    public static Map splitRepositoryLocations(IRepositoryResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IRepositoryResource>>();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            ArrayList<IRepositoryResource> tResources = (ArrayList<IRepositoryResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IRepositoryResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(resources[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(IResource[] resources) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<IResource>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<IResource>>();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = storage.getRepositoryLocation(resources[i]);
            ArrayList<IResource> tResources = (ArrayList<IResource>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<IResource>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(resources[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static Map splitRepositoryLocations(File[] files) throws Exception {
        HashMap<IRepositoryLocation, ArrayList<File>> repository2Resources = new HashMap<IRepositoryLocation, ArrayList<File>>();
        int i = 0;
        while (i < files.length) {
            IRepositoryResource resource = SVNFileStorage.instance().asRepositoryResource(files[i], false);
            IRepositoryLocation location = resource.getRepositoryLocation();
            ArrayList<File> tResources = (ArrayList<File>)repository2Resources.get(location);
            if (tResources == null) {
                tResources = new ArrayList<File>();
                repository2Resources.put(location, tResources);
            }
            tResources.add(files[i]);
            ++i;
        }
        return SVNUtility.combineLocationsByUUID(repository2Resources);
    }

    public static int getNodeKind(String path, int kind, boolean ignoreNone) {
        File f = new File(path);
        if (f.exists()) {
            return f.isDirectory() ? 2 : 1;
        }
        if (kind == 2) {
            return 2;
        }
        if (kind == 1) {
            return 1;
        }
        if (ignoreNone) {
            return 0;
        }
        String errMessage = SVNTeamPlugin.instance().getResource("Error.UnrecognizedNodeKind");
        throw new RuntimeException(MessageFormat.format(errMessage, String.valueOf(kind), path));
    }

    public static IRepositoryResource[] shrinkChildNodes(IRepositoryResource[] resources) {
        HashSet<IRepositoryResource> roots = new HashSet<IRepositoryResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            if (SVNUtility.hasRoots(roots, resources[i])) {
                roots.remove(resources[i]);
            }
            ++i;
        }
        return roots.toArray(new IRepositoryResource[roots.size()]);
    }

    public static IRepositoryResource[] getCommonParents(IRepositoryResource[] resources) {
        HashMap<IRepositoryResource, ArrayList<IRepositoryResource>> byRepositoryRoots = new HashMap<IRepositoryResource, ArrayList<IRepositoryResource>>();
        int i = 0;
        while (i < resources.length) {
            IRepositoryResource root = resources[i].getRoot();
            ArrayList<IRepositoryResource> tmp = (ArrayList<IRepositoryResource>)byRepositoryRoots.get(root);
            if (tmp == null) {
                tmp = new ArrayList<IRepositoryResource>();
                byRepositoryRoots.put(root, tmp);
            }
            tmp.add(resources[i]);
            ++i;
        }
        IRepositoryResource[] retVal = new IRepositoryResource[byRepositoryRoots.size()];
        int i2 = 0;
        Iterator it = byRepositoryRoots.values().iterator();
        while (it.hasNext()) {
            List tmp = (List)it.next();
            retVal[i2] = SVNUtility.getCommonParent(tmp.toArray(new IRepositoryResource[tmp.size()]));
            ++i2;
        }
        return retVal;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Info2 getLocationInfo(IRepositoryLocation location) throws Exception {
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        Info2[] infos = null;
        try {
            infos = proxy.info2(SVNUtility.encodeURL(location.getUrl()), Revision.HEAD, Revision.HEAD, false, new SVNNullProgressMonitor());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var3_5 = null;
            location.releaseSVNProxy(proxy);
            if (infos == null) return null;
        }
        if (infos.length <= 0) return null;
        Info2 info2 = infos[0];
        return info2;
    }

    public static String getAscendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.indexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(0, idx);
    }

    public static String getDescendant(IRepositoryResource resource) {
        String pathUpToRoot = SVNUtility.getPathUpToRoot(resource);
        int idx = pathUpToRoot.lastIndexOf(47);
        return idx == -1 ? pathUpToRoot : pathUpToRoot.substring(idx + 1);
    }

    public static String getPathUpToRoot(IRepositoryResource resource) {
        IRepositoryResource root = resource.getRoot();
        return root == resource ? resource.getName() : resource.getUrl().substring(root.getUrl().length() + 1);
    }

    private static boolean isMergeParts(IResource resource) {
        String ext = resource.getFileExtension();
        return ext != null && ext.matches("r(\\d)+");
    }

    private static Map combineLocationsByUUID(Map repository2Resources) throws Exception {
        Map.Entry entry;
        HashMap locationUtility2Resources = new HashMap();
        Iterator it = repository2Resources.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
            List tResources = (List)entry.getValue();
            RepositoryLocationUtility locationUtility = new RepositoryLocationUtility(location);
            ArrayList tResources2 = (ArrayList)locationUtility2Resources.get(locationUtility);
            if (tResources2 == null) {
                tResources2 = new ArrayList();
                locationUtility2Resources.put(locationUtility, tResources2);
            }
            tResources2.addAll(tResources);
        }
        repository2Resources.clear();
        it = locationUtility2Resources.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            RepositoryLocationUtility locationUtility = (RepositoryLocationUtility)entry.getKey();
            repository2Resources.put(locationUtility.location, (List)entry.getValue());
        }
        return repository2Resources;
    }

    private static boolean hasRoots(Set roots, IRepositoryResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static IRepositoryResource getCommonParent(IRepositoryResource[] resources) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        IRepositoryResource base = resources[0].getParent();
        while (base != null) {
            int startsCnt = 0;
            String baseUrl = base.getUrl();
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getUrl().startsWith(baseUrl)) {
                    ++startsCnt;
                }
                ++i;
            }
            if (startsCnt == resources.length) break;
            base = base.getParent();
        }
        return base;
    }

    private static IRepositoryRoot getRootLocation(IRepositoryResource resource, String rootName) {
        IRepositoryLocation location = resource.getRepositoryLocation();
        IRepositoryRoot root = (IRepositoryRoot)resource.getRoot();
        if (!location.isStructureEnabled()) {
            return root;
        }
        int rootKind = root.getKind();
        if (rootKind == 4) {
            return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
        }
        if (rootKind == 0) {
            IRepositoryResource parent = root.getParent();
            if (parent == null) {
                return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
            }
            IRepositoryRoot tmp = (IRepositoryRoot)parent.getRoot();
            rootKind = tmp.getKind();
            if (rootKind == 4) {
                return (IRepositoryRoot)root.asRepositoryContainer(rootName, false);
            }
            root = tmp;
        }
        IRepositoryResource rootParent = root.getParent();
        return (IRepositoryRoot)rootParent.asRepositoryContainer(rootName, false);
    }

    private SVNUtility() {
    }
}

