/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.annotate.AnnotateEditorInput;
import org.polarion.team.svn.ui.history.RepositoryFileEditorInput;
import org.polarion.team.svn.ui.repository.model.IResourceTreeNode;

public abstract class AbstractSVNView
extends ViewPart
implements IResourceStatesListener {
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected String viewDescription;
    protected Object lastSelectedElement;
    protected boolean isLinkWithEditorEnabled;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                AbstractSVNView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == AbstractSVNView.this) {
                AbstractSVNView.this.editorActivated(AbstractSVNView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == AbstractSVNView.this) {
                AbstractSVNView.this.editorActivated(AbstractSVNView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    protected IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == AbstractSVNView.this) {
                AbstractSVNView.this.editorActivated(AbstractSVNView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    protected ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                AbstractSVNView.this.lastSelectedElement = structSelection.getFirstElement();
                if (!AbstractSVNView.this.isLinkWithEditorEnabled || !AbstractSVNView.this.isPageVisible()) {
                    return;
                }
                if (AbstractSVNView.this.lastSelectedElement != null) {
                    if (AbstractSVNView.this.lastSelectedElement instanceof IResource) {
                        IResource resource = (IResource)AbstractSVNView.this.lastSelectedElement;
                        AbstractSVNView.this.updateViewInput(resource);
                        AbstractSVNView.this.lastSelectedElement = null;
                    } else if (AbstractSVNView.this.lastSelectedElement instanceof IAdaptable) {
                        if (AbstractSVNView.this.lastSelectedElement instanceof IResourceTreeNode) {
                            IResourceTreeNode remote = (IResourceTreeNode)AbstractSVNView.this.lastSelectedElement;
                            AbstractSVNView.this.updateViewInput(remote.getRepositoryResource());
                        } else {
                            Object adapted;
                            IAdaptable iAdaptable = (IAdaptable)AbstractSVNView.this.lastSelectedElement;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((adapted = iAdaptable.getAdapter((Class)clazz)) instanceof IResource) {
                                AbstractSVNView.this.updateViewInput((IResource)adapted);
                            }
                        }
                    }
                }
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public AbstractSVNView(String viewDescription) {
        this.viewDescription = viewDescription;
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
    }

    public void createPartControl(Composite parent) {
        if (this.needsLinkWithEditorAndSelection()) {
            this.getSite().getPage().addPartListener(this.partListener);
            this.getSite().getPage().addPartListener(this.partListener2);
            this.getSite().getPage().addSelectionListener(this.selectionListener);
        }
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (this.wcResource == null) {
            return;
        }
        if (event.contains(this.wcResource) || event.contains((IResource)this.wcResource.getProject())) {
            if (!this.wcResource.exists() || !FileUtility.isConnected((IResource)this.wcResource)) {
                this.disconnectView();
            } else {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.wcResource);
                if (local == null || IStateFilter.SF_NONVERSIONED.accept(this.wcResource, local.getStatus(), local.getChangeMask())) {
                    this.disconnectView();
                }
            }
            this.refreshView();
        }
    }

    protected void showResourceLabel() {
        String resourceName;
        if (this.wcResource != null) {
            String path = this.wcResource.getFullPath().toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String message = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceSelected");
            resourceName = MessageFormat.format(message, this.viewDescription, path);
        } else if (this.repositoryResource != null) {
            String message = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceSelected");
            resourceName = MessageFormat.format(message, this.viewDescription, this.repositoryResource.getUrl());
        } else {
            resourceName = SVNTeamUIPlugin.instance().getResource("SVNView.ResourceNotSelected");
        }
        this.setContentDescription(resourceName);
    }

    protected boolean isPageVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        if (this.needsLinkWithEditorAndSelection()) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.getSite().getPage().removePartListener(this.partListener2);
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
        }
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.removeResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
        super.dispose();
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor != null && !this.isPageVisible()) {
            this.lastSelectedElement = editor;
        }
        if (editor == null || !this.isLinkWithEditorEnabled || !this.isPageVisible()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input != null && !(input instanceof AnnotateEditorInput)) {
            if (input instanceof IFileEditorInput || input instanceof SyncInfoCompareInput) {
                Object adapter;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = input.getAdapter((Class)clazz)) instanceof IFile) {
                    this.updateViewInput((IResource)((IFile)adapter));
                }
            } else if (input instanceof RepositoryFileEditorInput) {
                this.updateViewInput(((RepositoryFileEditorInput)input).getRepositoryResource());
            }
        }
    }

    protected void updateViewInput(IResource resource) {
    }

    protected void updateViewInput(IRepositoryResource resource) {
    }

    protected abstract boolean needsLinkWithEditorAndSelection();

    protected abstract void disconnectView();

    protected abstract void refreshView();
}

