/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.ICancellableOperationWrapper;
import org.polarion.team.svn.ui.utility.IOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public abstract class AbstractSVNTeamAction
extends TeamAction {
    private IWorkbenchWindow window;
    private Shell shell;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                AbstractSVNTeamAction.this.checkSelection((IStructuredSelection)selection);
            }
        }
    };

    public final void run(final IAction action) {
        ProgressMonitorUtility.doTaskExternal((IActionOperation)new AbstractNonLockingOperation("Operation.CallMenuAction"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (AbstractSVNTeamAction.this.isEnabled()) {
                    AbstractSVNTeamAction.this.runImpl(action);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    public abstract boolean isEnabled();

    public abstract void runImpl(IAction var1);

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
    }

    protected ICancellableOperationWrapper runBusy(IActionOperation operation) {
        return UIMonitorUtility.doTaskBusy(operation, this.getOperationWrapperFactory());
    }

    protected ICancellableOperationWrapper runNow(IActionOperation operation, boolean cancellable) {
        return UIMonitorUtility.doTaskNow(this.getShell(), operation, cancellable, this.getOperationWrapperFactory());
    }

    protected ICancellableOperationWrapper runScheduled(IActionOperation operation) {
        return UIMonitorUtility.doTaskScheduled(this.getTargetPart(), operation, this.getOperationWrapperFactory());
    }

    protected IOperationWrapperFactory getOperationWrapperFactory() {
        return new DefaultOperationWrapperFactory();
    }

    protected void handleException(Exception ex) {
        this.handle(ex, SVNTeamUIPlugin.instance().getResource("Error.ActionFailed"), SVNTeamUIPlugin.instance().getResource("Error.ActionFailed.Message"));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                action.setEnabled(false);
                return;
            }
            this.checkSelection((IStructuredSelection)selection);
            super.selectionChanged(action, selection);
        }
        catch (Throwable ex) {
            LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.MenuEnablement"), (Throwable)ex);
        }
    }

    public Object[] getSelectedResources(Class c) {
        return TeamAction.getSelectedAdaptables((ISelection)this.getSelection(), (Class)c);
    }

    protected Shell getShell() {
        return this.shell != null ? this.shell : super.getShell();
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = this.window.getShell();
        this.window.getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public void dispose() {
        if (this.window != null) {
            this.window.getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    protected abstract void checkSelection(IStructuredSelection var1);

    protected abstract IStructuredSelection getSelection();
}

