/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class FilterManager
implements IPropertyChangeListener,
IResourceStatesListener {
    private static FilterManager instance = null;
    protected Map filters2condition = new HashMap();
    protected Map recursiveFilters2condition = new HashMap();
    protected MapChecker flatChecker = new MapChecker(this.filters2condition);
    protected MapChecker recursiveChecker = new MapChecker(this.recursiveFilters2condition);
    protected boolean dirty;
    static /* synthetic */ Class class$0;

    public static synchronized FilterManager instance() {
        if (instance == null) {
            instance = new FilterManager();
        }
        return instance;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SVNTeamPreferences.fullDecorationName("compute.deep")) || event.getProperty().equals(SVNTeamPreferences.fullCoreName("svnclient"))) {
            this.clear();
        }
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        this.clear();
    }

    public void clear() {
        this.dirty = true;
    }

    public boolean checkForResourcesPresenceRecursive(IResource[] selectedResources, IStateFilter stateFilter) {
        return this.checkForResourcesPresence(selectedResources, stateFilter, true);
    }

    public boolean checkForResourcesPresence(IResource[] selectedResources, IStateFilter stateFilter, boolean recursive) {
        Map filtersMap;
        Boolean retVal;
        boolean computeDeep = SVNTeamPreferences.getDecorationBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "compute.deep");
        if (this.dirty) {
            this.dirty = false;
            if (!this.connectedToSVN(selectedResources)) {
                this.flatChecker.clearFilters();
                this.flatChecker.checkDisallowed();
                this.recursiveChecker.clearFilters();
                this.recursiveChecker.checkDisallowed();
                return false;
            }
            if (this.filters2condition.size() > 0) {
                this.flatChecker.clearFilters();
                FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)this.flatChecker, (int)0);
                this.flatChecker.checkDisallowed();
            }
            if (computeDeep) {
                if (this.recursiveFilters2condition.size() > 0) {
                    this.recursiveChecker.clearFilters();
                    FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)this.recursiveChecker, (int)2);
                    this.recursiveChecker.checkDisallowed();
                }
            } else {
                this.recursiveChecker.setAllTo(Boolean.TRUE);
            }
        }
        if ((retVal = (Boolean)(filtersMap = recursive ? this.recursiveFilters2condition : this.filters2condition).get(stateFilter)) == null) {
            if (!computeDeep && recursive) {
                retVal = Boolean.TRUE;
                filtersMap.put(stateFilter, retVal);
            } else {
                boolean containsResources = FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)stateFilter, (int)(recursive ? 2 : 0));
                retVal = containsResources;
                filtersMap.put(stateFilter, retVal);
            }
        }
        return retVal;
    }

    protected boolean connectedToSVN(IResource[] selectedResources) {
        int i = 0;
        while (i < selectedResources.length) {
            if (!FileUtility.isConnected((IResource)selectedResources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private FilterManager() {
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
    }

    protected static class MapChecker
    implements IStateFilter {
        protected Map filterMap;

        public MapChecker(Map filterMap) {
            this.filterMap = filterMap;
        }

        public void clearFilters() {
            Iterator it = this.filterMap.keySet().iterator();
            while (it.hasNext()) {
                this.filterMap.put(it.next(), null);
            }
        }

        public void setAllTo(Boolean value) {
            Iterator it = this.filterMap.keySet().iterator();
            while (it.hasNext()) {
                this.filterMap.put(it.next(), value);
            }
        }

        public boolean accept(IResource resource, String state, int mask) {
            boolean retVal = true;
            Iterator it = this.filterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) continue;
                IStateFilter filter = (IStateFilter)entry.getKey();
                boolean value = filter.accept(resource, state, mask);
                retVal &= value;
                if (!value) continue;
                this.filterMap.put(filter, Boolean.TRUE);
            }
            return retVal;
        }

        public void checkDisallowed() {
            Iterator it = this.filterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) continue;
                this.filterMap.put(entry.getKey(), Boolean.FALSE);
            }
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    }
}

