/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.action.IResourceSelector;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.local.AddToSVNPanel;

public class QueryResourceAddition {
    protected IResourceSelector selector;
    protected Shell shell;

    public QueryResourceAddition(IResourceSelector selector, Shell shell) {
        this.selector = selector;
        this.shell = shell;
    }

    public IResource[] queryAddition() {
        IResource[] tRes = FileUtility.addOperableParents((IResource[])QueryResourceAddition.getSelectedForAddition(this.selector), (IStateFilter)IStateFilter.SF_NONVERSIONED);
        if (tRes.length > 0) {
            IResource[] userSelectedResources = this.selector.getSelectedResources();
            AddToSVNPanel panel = new AddToSVNPanel(tRes, userSelectedResources);
            DefaultDialog dialog = new DefaultDialog(this.shell, panel);
            IResource[] iResourceArray = tRes = dialog.open() != 0 ? null : panel.getSelectedResources();
            if (tRes != null && tRes.length == 0) {
                tRes = null;
            }
        }
        return tRes == null ? null : FileUtility.addOperableParents((IResource[])tRes, (IStateFilter)IStateFilter.SF_NONVERSIONED);
    }

    public IResource[][] queryAdditionsSeparated() {
        HashSet<IResource> nonRecursive = new HashSet<IResource>(Arrays.asList(this.selector.getSelectedResources(IStateFilter.SF_IGNORED)));
        HashSet<IResource> recursive = new HashSet<IResource>(Arrays.asList(this.selector.getSelectedResourcesRecursive(IStateFilter.SF_NEW)));
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.addAll(nonRecursive);
        resources.addAll(recursive);
        List<IResource> parents = Arrays.asList(FileUtility.getOperableParents((IResource[])resources.toArray(new IResource[resources.size()]), (IStateFilter)IStateFilter.SF_NONVERSIONED));
        nonRecursive.addAll(parents);
        resources.addAll(parents);
        IResource[] tRes = resources.toArray(new IResource[resources.size()]);
        if (tRes.length > 0) {
            IResource[] userSelectedResources = this.selector.getSelectedResources();
            AddToSVNPanel panel = new AddToSVNPanel(tRes, userSelectedResources);
            DefaultDialog dialog = new DefaultDialog(this.shell, panel);
            if (dialog.open() != 0) {
                tRes = null;
            } else {
                tRes = panel.getSelectedResources();
                if (tRes.length == 0) {
                    tRes = null;
                } else if (panel.getNotSelectedResources().length > 0) {
                    nonRecursive = new HashSet<IResource>(Arrays.asList(tRes));
                    nonRecursive.addAll(Arrays.asList(FileUtility.addOperableParents((IResource[])tRes, (IStateFilter)IStateFilter.SF_NONVERSIONED)));
                    recursive.clear();
                }
            }
        }
        if (tRes != null) {
            IResource[][] retVal = new IResource[][]{nonRecursive.toArray(new IResource[nonRecursive.size()]), recursive.toArray(new IResource[recursive.size()]), FileUtility.shrinkChildNodes((IResource[])tRes)};
            return retVal;
        }
        return null;
    }

    public static IResource[] getSelectedForAddition(IResourceSelector selector) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.addAll(Arrays.asList(selector.getSelectedResources(IStateFilter.SF_IGNORED)));
        resources.addAll(Arrays.asList(selector.getSelectedResourcesRecursive(IStateFilter.SF_NEW)));
        return resources.toArray(new IResource[resources.size()]);
    }
}

