/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AddToSVNOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.FreezeExternalsOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreExternalsOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SwitchOperation;
import org.polarion.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.OperationErrorDialog;
import org.polarion.team.svn.ui.panel.common.AbstractBranchTagPanel;
import org.polarion.team.svn.ui.panel.common.BranchPanel;
import org.polarion.team.svn.ui.panel.common.TagPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class BranchTagAction
extends AbstractNonRecursiveTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int actionType;

    public BranchTagAction(int actionType) {
        this.actionType = actionType;
    }

    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        ArrayList<ILocalResource> localOperateResources = new ArrayList<ILocalResource>();
        ArrayList<IRepositoryResource> remoteOperateResources = new ArrayList<IRepositoryResource>();
        ArrayList<IResource> operateResources = new ArrayList<IResource>();
        IRepositoryLocation first = SVNRemoteStorage.instance().asRepositoryResource(resources[0]).getRepositoryLocation();
        int i = 0;
        while (i < resources.length) {
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resources[i]);
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resources[i]);
            if (local != null && remote != null) {
                if (remote.getRepositoryLocation() != first) {
                    new OperationErrorDialog(this.getShell(), SVNTeamUIPlugin.instance().getResource(this.actionType == 0 ? "BranchTagAction.Error.Branch" : "BranchTagAction.Error.Tag"), 0).open();
                    return;
                }
                operateResources.add(resources[i]);
                localOperateResources.add(local);
                remoteOperateResources.add(remote);
            }
            ++i;
        }
        if (remoteOperateResources.size() > 0) {
            IRepositoryResource[] remoteResources = remoteOperateResources.toArray(new IRepositoryResource[remoteOperateResources.size()]);
            if (!OperationErrorDialog.isAcceptableAtOnce(remoteResources, SVNTeamUIPlugin.instance().getResource(this.actionType == 0 ? "BranchTagAction.Error.Branch" : "BranchTagAction.Error.Tag"), this.getShell())) {
                return;
            }
            AbstractBranchTagPanel panel = null;
            Set nodeNames = new HashSet();
            boolean respectProjectStructure = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
            if (respectProjectStructure && remoteResources[0].getRepositoryLocation().isStructureEnabled()) {
                nodeNames = org.polarion.team.svn.ui.action.remote.BranchTagAction.getExistingNodeNames((IRepositoryContainer)(this.actionType == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]) : SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0])));
            }
            panel = this.actionType == 0 ? new BranchPanel(SVNUtility.getBranchesLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources) : new TagPanel(SVNUtility.getTagsLocation((IRepositoryResource)remoteResources[0]), true, nodeNames, resources);
            DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
            if (dialog.open() == 0) {
                IRepositoryResource destination = panel.getDestination();
                IResource[] operateResourcesArr = operateResources.toArray(new IResource[operateResources.size()]);
                IResource[] newResources = panel.getSelectedResources();
                boolean multipleLayout = this.isMultipleLayout(resources, remoteOperateResources);
                PreparedBranchTagOperation mainOp = new PreparedBranchTagOperation(this.actionType == 0 ? "Branch" : "Tag", operateResourcesArr, remoteResources, destination, panel.getMessage(), multipleLayout);
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                if (newResources != null && newResources.length > 0) {
                    op.add((IActionOperation)new AddToSVNOperation(newResources, false));
                }
                if (panel.isFreezeExternals()) {
                    FreezeExternalsOperation freezeOp = new FreezeExternalsOperation(resources);
                    op.add((IActionOperation)freezeOp);
                    op.add((IActionOperation)mainOp, new IActionOperation[]{freezeOp});
                    op.add((IActionOperation)new RestoreExternalsOperation(freezeOp));
                } else {
                    op.add((IActionOperation)mainOp);
                }
                if (newResources != null && newResources.length > 0) {
                    op.add((IActionOperation)new RevertOperation(newResources, false));
                }
                if (panel.isStartWithSelected()) {
                    IResource[] switchedResources = new IResource[localOperateResources.size()];
                    int i2 = 0;
                    Iterator iter = localOperateResources.iterator();
                    while (iter.hasNext()) {
                        switchedResources[i2] = ((ILocalResource)iter.next()).getResource();
                        ++i2;
                    }
                    SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(switchedResources);
                    op.add((IActionOperation)saveOp);
                    op.add((IActionOperation)new SwitchOperation(switchedResources, (IRepositoryResourceProvider)mainOp), new IActionOperation[]{mainOp});
                    op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                    op.add((IActionOperation)new ClearLocalStatusesOperation(operateResourcesArr));
                    op.add((IActionOperation)new RefreshResourcesOperation(operateResourcesArr));
                }
                this.runNow((IActionOperation)op, false);
            }
        }
    }

    protected boolean isMultipleLayout(IResource[] resources, List remoteOperateResources) {
        boolean multipleLayout = false;
        if (resources.length == 1 && resources[0] instanceof IProject) {
            IRepositoryResource remote = (IRepositoryResource)remoteOperateResources.get(0);
            IRepositoryLocation location = remote.getRepositoryLocation();
            String trunkLocation = SVNUtility.getProposedTrunkLocation((IRepositoryLocation)location);
            if (location.isStructureEnabled() && remote.getUrl().startsWith(trunkLocation)) {
                multipleLayout = !remote.getUrl().equals(trunkLocation);
            }
        }
        return multipleLayout;
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }
}

