/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.ICommitDialog;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.utility.CommitActionUtility;

public class CommitAction
extends AbstractRecursiveTeamAction {
    public static final IStateFilter SF_ANY_CHANGE = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return IStateFilter.SF_ANY_CHANGE.accept(resource, state, mask) && state != "Conflicting";
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };

    public void runImpl(IAction action) {
        CommitActionUtility commitUtility = new CommitActionUtility(this);
        String proposedComment = SVNChangeSetCapability.getProposedComment(commitUtility.getAllResources());
        CommitPanel commitPanel = new CommitPanel(commitUtility.getAllResources(), this.getSelectedResources(), 0, proposedComment);
        ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(this.getShell(), commitUtility.getAllResourcesSet(), commitPanel);
        if (commitDialog.open() == 0) {
            if (commitPanel.getResourcesChanged()) {
                commitUtility.initialize(this);
            }
            CompositeOperation op = commitUtility.getCompositeCommitOperation(commitPanel.getSelectedResources(), commitPanel.getNotSelectedResources(), commitDialog.getMessage(), commitPanel.getKeepLocks(), this.getShell(), this.getTargetPart(), true);
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(SF_ANY_CHANGE);
    }
}

