/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractWorkingCopyAction;
import org.polarion.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.CompareResourcesOperation;
import org.polarion.team.svn.ui.operation.ShowHistoryViewOperation;
import org.polarion.team.svn.ui.panel.common.InputRevisionPanel;

public class CompareWithRevisionAction
extends AbstractWorkingCopyAction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runImpl(IAction action) {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IResource left = this.getSelectedResources()[0];
        IRepositoryResource right = null;
        ILocalResource localLeft = storage.asLocalResource(left);
        if (localLeft == null) {
            return;
        }
        if (localLeft.isCopied()) {
            ISVNClientWrapper proxy;
            IRepositoryLocation location;
            block9: {
                block8: {
                    location = storage.getRepositoryLocation(left);
                    proxy = location.acquireSVNProxy();
                    try {
                        Status status = SVNUtility.getSVNInfoForNotConnected((IResource)left);
                        if (status == null) {
                            Object var9_9 = null;
                            break block8;
                        }
                        right = left instanceof IFile ? location.asRepositoryFile(status.urlCopiedFrom, false) : location.asRepositoryContainer(status.urlCopiedFrom, false);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        location.releaseSVNProxy(proxy);
                        throw throwable;
                    }
                }
                location.releaseSVNProxy(proxy);
                return;
            }
            Object var9_11 = null;
            location.releaseSVNProxy(proxy);
        } else {
            right = storage.asRepositoryResource(left);
        }
        InputRevisionPanel panel = new InputRevisionPanel(right, SVNTeamUIPlugin.instance().getResource("CompareWithRevisionAction.InputRevisionPanel.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            this.runScheduled((IActionOperation)new CompareResourcesOperation(left, panel.getSelectedRevision(), right.getPegRevision()));
            this.runBusy((IActionOperation)new ShowHistoryViewOperation(left, 2, 2));
        }
    }

    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(CompareWithWorkingCopyAction.COMPARE_FILTER);
    }
}

