/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.action.AbstractWorkingCopyAction;
import org.polarion.team.svn.ui.operation.CompareResourcesOperation;

public class CompareWithWorkingCopyAction
extends AbstractWorkingCopyAction {
    public static final IStateFilter COMPARE_FILTER = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            SVNRemoteStorage storage;
            ILocalResource local;
            if (!(IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask) || (local = (storage = SVNRemoteStorage.instance()).asLocalResource(resource)) != null && local.isCopied())) {
                return false;
            }
            return CoreExtensionsManager.instance().getSVNClientWrapperFactory().isCompareFoldersAllowed() || resource instanceof IFile;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask);
        }
    };

    public void runImpl(IAction action) {
        IResource left = this.getSelectedResources()[0];
        this.runScheduled((IActionOperation)new CompareResourcesOperation(left, Revision.BASE, null));
    }

    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(COMPARE_FILTER);
    }
}

