/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.ExportOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractWorkingCopyAction;
import org.polarion.team.svn.ui.operation.CorrectRevisionOperation;

public class ExportAction
extends AbstractWorkingCopyAction {
    public void runImpl(IAction action) {
        IResource localTo = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED)[0];
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryResource remote = storage.asRepositoryResource(localTo);
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell());
        fileDialog.setText(SVNTeamUIPlugin.instance().getResource("ExportAction.Select.Title"));
        fileDialog.setMessage(SVNTeamUIPlugin.instance().getResource("ExportAction.Select.Description"));
        String path = fileDialog.open();
        if (path != null) {
            ExportOperation mainOp = new ExportOperation(remote, path);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            ILocalResource local = storage.asLocalResource(localTo);
            if (local != null) {
                op.add((IActionOperation)new CorrectRevisionOperation(null, remote, local.getRevision(), localTo));
            }
            op.add((IActionOperation)mainOp);
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }
}

