/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.LockOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.local.LockPanel;

public class LockAction
extends AbstractRecursiveTeamAction {
    protected static IStateFilter SF_NONLOCKED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (resource instanceof IFile && IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask)) {
                if (resource != null) {
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                    return local != null && !local.isLocked();
                }
                return true;
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return IStateFilter.SF_EXCLUDE_DELETED.accept(resource, state, mask);
        }
    };

    public void runImpl(IAction action) {
        IResource[] selectedResources = this.getSelectedResources();
        boolean containsFolder = false;
        int i = 0;
        while (i < selectedResources.length) {
            if (selectedResources[i] instanceof IContainer) {
                containsFolder = true;
                break;
            }
            ++i;
        }
        LockPanel commentPanel = new LockPanel(!containsFolder);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            IResource[] resources = this.getSelectedResourcesRecursive(SF_NONLOCKED, commentPanel.isRecursive() ? 2 : 1);
            LockOperation mainOp = new LockOperation(resources, commentPanel.getMessage(), commentPanel.getForce());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(SF_NONLOCKED);
    }
}

