/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.JavaHLMergeOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.AdvancedDialog;
import org.polarion.team.svn.ui.dialog.OperationErrorDialog;
import org.polarion.team.svn.ui.operation.ShowMergeViewOperation;
import org.polarion.team.svn.ui.panel.local.JavaHLMergePanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class MergeAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, SVNTeamUIPlugin.instance().getResource("MergeAction.MergeError"), this.getShell())) {
            return;
        }
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resources[0]);
        ILocalResource localTo = SVNRemoteStorage.instance().asLocalResource(resources[0]);
        if (localTo == null) {
            return;
        }
        long revision = localTo.getRevision();
        if (resources.length > 1) {
            revision = -1L;
            remote = remote.getRoot();
        }
        JavaHLMergePanel panel = new JavaHLMergePanel(resources, remote, revision);
        AdvancedDialog dialog = new AdvancedDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            if (panel.isAdvancedMode() || SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useJavaHL")) {
                JavaHLMergeOperation mainOp = new JavaHLMergeOperation(resources, panel.getFirstSelection(), panel.getSecondSelection(), false, panel.getIgnoreAncestry());
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                op.add((IActionOperation)saveOp);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(resources)));
                this.runScheduled((IActionOperation)op);
            } else {
                this.runScheduled((IActionOperation)new ShowMergeViewOperation(resources, panel.getSelection(), this.getTargetPart(), panel.getStartRevision()));
            }
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }
}

