/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.UpdateOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.ReplaceWarningDialog;
import org.polarion.team.svn.ui.panel.common.InputRevisionPanel;

public class ReplaceWithRevisionAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        ReplaceWarningDialog dialog;
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IResource resource = this.getSelectedResources(IStateFilter.SF_ONREPOSITORY)[0];
        IRepositoryResource remote = storage.asRepositoryResource(resource);
        InputRevisionPanel panel = new InputRevisionPanel(remote, SVNTeamUIPlugin.instance().getResource("ReplaceWithRevisionAction.InputRevisionPanel.Title"));
        DefaultDialog selectionDialog = new DefaultDialog(this.getShell(), panel);
        if (selectionDialog.open() == 0 && (dialog = new ReplaceWarningDialog(this.getShell())).open() == 0) {
            IResource[] resources = this.getSelectedResources(IStateFilter.SF_ONREPOSITORY);
            CompositeOperation op = new CompositeOperation("Operation.ReplaceWithRevision");
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            RevertOperation revertOp = new RevertOperation(resources, true);
            op.add((IActionOperation)revertOp);
            RemoveNonVersionedResourcesOperation removeOp = new RemoveNonVersionedResourcesOperation(resources, true);
            op.add((IActionOperation)removeOp, new IActionOperation[]{revertOp});
            op.add((IActionOperation)new UpdateOperation(resources, panel.getSelectedRevision(), true), new IActionOperation[]{revertOp, removeOp});
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.getSelectedResources().length == 1 && this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }
}

