/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RemoveNonVersionedResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.RevertOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.local.RevertPanel;

public class RevertAction
extends AbstractRecursiveTeamAction {
    public static IStateFilter SF_REVERTABLE_OR_NEW = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return IStateFilter.SF_REVERTABLE.accept(resource, state, mask) || IStateFilter.SF_NEW.accept(resource, state, mask);
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return IStateFilter.SF_REVERTABLE.allowsRecursion(resource, state, mask) || IStateFilter.SF_NEW.allowsRecursion(resource, state, mask);
        }
    };

    public void runImpl(IAction action) {
        IResource[] changedResources = this.getSelectedResourcesRecursive(SF_REVERTABLE_OR_NEW);
        IResource[] userSelectedResources = this.getSelectedResources();
        CompositeOperation revertOp = RevertAction.getRevertOperation(this.getShell(), changedResources, userSelectedResources);
        if (revertOp != null) {
            this.runScheduled((IActionOperation)revertOp);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(SF_REVERTABLE_OR_NEW);
    }

    public static CompositeOperation getRevertOperation(Shell shell, IResource[] changedResources, IResource[] selectedResources) {
        RevertPanel panel = new RevertPanel(changedResources, selectedResources);
        DefaultDialog rDlg = new DefaultDialog(shell, panel);
        if (rDlg.open() == 0) {
            boolean recursive = panel.getNotSelectedResources().length == 0;
            changedResources = panel.getSelectedResources();
            IResource[] revertableResources = FileUtility.getResourcesRecursive((IResource[])changedResources, (IStateFilter)IStateFilter.SF_REVERTABLE, (int)(recursive ? 2 : 0));
            RevertOperation mainOp = new RevertOperation(revertableResources, recursive);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(changedResources);
            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            if (panel.getRemoveNonVersioned()) {
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_CACHE), new IActionOperation[]{mainOp});
                op.add((IActionOperation)new RemoveNonVersionedResourcesOperation(changedResources, true), new IActionOperation[]{mainOp});
            }
            op.add((IActionOperation)restoreOp);
            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_ALL));
            return op;
        }
        return null;
    }
}

