/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.UnlockOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.UnlockResourcesDialog;

public class UnlockAction
extends AbstractRecursiveTeamAction {
    protected static final IStateFilter SF_LOCKED = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            if (IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask)) {
                if (resource != null) {
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                    return local != null && local.isLocked();
                }
                return true;
            }
            return false;
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return IStateFilter.SF_ONREPOSITORY.accept(resource, state, mask);
        }
    };

    public void runImpl(IAction action) {
        IResource[] checkRecursive = this.getSelectedResources();
        boolean recursive = false;
        int i = 0;
        while (i < checkRecursive.length) {
            if (checkRecursive[i].getType() != 1) {
                recursive = true;
                break;
            }
            ++i;
        }
        UnlockResourcesDialog dialog = new UnlockResourcesDialog(this.getShell(), recursive);
        if (dialog.open() == 0) {
            IResource[] resources = this.getSelectedResourcesRecursive(SF_LOCKED, dialog.isRecursive() ? 2 : 1);
            UnlockOperation mainOp = new UnlockOperation(resources);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(SF_LOCKED);
    }
}

