/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.AbstractCopyMoveResourcesOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.polarion.team.svn.ui.panel.common.CommentPanel;
import org.polarion.team.svn.ui.panel.common.RepositoryTreePanel;

public abstract class AbstractCopyMoveAction
extends AbstractRepositoryTeamAction {
    protected String operationId;

    public AbstractCopyMoveAction(String operationId) {
        this.operationId = operationId;
    }

    public void runImpl(IAction action) {
        IRepositoryResource destination;
        RepositoryTreePanel panel = new RepositoryTreePanel(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.operationId) + ".Select.Title"), this.getSelectedRepositoryResources(), this.operationId.toLowerCase().equals("copy"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0 && (destination = panel.getSelectedResource()) != null) {
            CommentPanel commentPanel = new CommentPanel(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.operationId) + ".Comment.Title"));
            dialog = new DefaultDialog(this.getShell(), commentPanel);
            if (dialog.open() == 0) {
                String message = commentPanel.getMessage();
                IRepositoryResource[] selected = this.getSelectedRepositoryResources();
                AbstractCopyMoveResourcesOperation moveOp = this.makeCopyOperation(destination, selected, message);
                CompositeOperation op = new CompositeOperation(moveOp.getId());
                op.add((IActionOperation)moveOp);
                op.add((IActionOperation)this.makeRefreshOperation(destination, selected));
                this.runScheduled((IActionOperation)op);
            }
        }
    }

    protected abstract AbstractCopyMoveResourcesOperation makeCopyOperation(IRepositoryResource var1, IRepositoryResource[] var2, String var3);

    protected abstract RefreshRemoteResourcesOperation makeRefreshOperation(IRepositoryResource var1, IRepositoryResource[] var2);
}

