/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.SVNTeamProvider;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.NotifyProjectStatesChangedOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.management.DisconnectOperation;
import org.polarion.team.svn.core.operation.remote.management.DiscardRepositoryLocationsOperation;
import org.polarion.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.polarion.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.polarion.team.svn.ui.panel.remote.DiscardLocationFailurePanel;

public class DiscardRepositoryLocationAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IProject[] tmp;
        IRepositoryLocation[] locations = this.getSelectedRepositoryLocations();
        List<IRepositoryLocation> selection = Arrays.asList(locations);
        ArrayList<IRepositoryLocation> operateLocations = new ArrayList<IRepositoryLocation>();
        operateLocations.addAll(Arrays.asList(locations));
        ArrayList<IProject> connectedProjects = new ArrayList<IProject>();
        HashSet<IRepositoryLocation> connectedLocations = new HashSet<IRepositoryLocation>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            SVNTeamProvider provider;
            tmp = RepositoryProvider.getProvider((IProject)projects[i]);
            if (tmp != null && "org.polarion.team.svn.core.svnnature".equals(tmp.getID()) && selection.contains((provider = (SVNTeamProvider)tmp).getRepositoryLocation())) {
                connectedProjects.add(projects[i]);
                connectedLocations.add(provider.getRepositoryLocation());
                operateLocations.remove(provider.getRepositoryLocation());
            }
            ++i;
        }
        if (operateLocations.size() > 0) {
            locations = operateLocations.toArray(new IRepositoryLocation[operateLocations.size()]);
            DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(this.getShell(), locations.length == 1, 0);
            if (dialog.open() == 0) {
                this.doDiscard(locations, null);
            }
        }
        if (connectedProjects.size() > 0) {
            ArrayList<String> locationsList = new ArrayList<String>();
            Iterator iter = connectedLocations.iterator();
            while (iter.hasNext()) {
                IRepositoryLocation location = (IRepositoryLocation)iter.next();
                locationsList.add(location.getLabel());
            }
            tmp = connectedProjects.toArray(new IProject[connectedProjects.size()]);
            DiscardLocationFailurePanel panel = new DiscardLocationFailurePanel(locationsList.toArray(new String[locationsList.size()]), tmp);
            int retVal = new DefaultDialog(this.getShell(), panel).open();
            if (retVal == 0 || retVal == 1) {
                DisconnectOperation disconnectOp = new DisconnectOperation(tmp, false);
                CompositeOperation op = new CompositeOperation(disconnectOp.getId());
                op.add((IActionOperation)new NotifyProjectStatesChangedOperation(tmp, 3));
                op.add((IActionOperation)disconnectOp);
                if (retVal == 0) {
                    op.add((IActionOperation)new RefreshResourcesOperation((IResource[])tmp, 2, RefreshResourcesOperation.REFRESH_ALL));
                } else {
                    op.add((IActionOperation)new NotifyProjectStatesChangedOperation(tmp, 5));
                    op.add((IActionOperation)new AbstractWorkingCopyOperation("Operation.DeleteProjects", (IResource[])tmp){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            IProject[] projects = (IProject[])this.operableData();
                            int i = 0;
                            while (i < projects.length && !monitor.isCanceled()) {
                                IProject current = projects[i];
                                this.protectStep(new IUnprotectedOperation(this, current){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ IProject val$current;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$current = iProject;
                                    }

                                    public void run(IProgressMonitor monitor) throws Exception {
                                        this.val$current.delete(true, monitor);
                                    }
                                }, monitor, projects.length);
                                ++i;
                            }
                        }
                    });
                }
                this.doDiscard(locations, (IActionOperation)op);
            }
        }
    }

    protected void doDiscard(IRepositoryLocation[] locations, IActionOperation disconnectOp) {
        DiscardRepositoryLocationsOperation mainOp = new DiscardRepositoryLocationsOperation(locations);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        if (disconnectOp != null) {
            op.add(disconnectOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{disconnectOp});
        } else {
            op.add((IActionOperation)mainOp);
        }
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(false));
        this.runNow((IActionOperation)op, false);
    }

    public boolean isEnabled() {
        return this.getSelectedRepositoryLocations().length > 0;
    }
}

