/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote.management;

import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.polarion.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.polarion.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.polarion.team.svn.ui.panel.common.InputRevisionPanel;

public class SelectResourceRevisionAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        this.runImpl(this.getSelectedRepositoryResources()[0]);
    }

    protected void runImpl(IRepositoryResource resource) {
        IRepositoryLocation location = resource.getRepositoryLocation();
        InputRevisionPanel panel = new InputRevisionPanel(resource, SVNTeamUIPlugin.instance().getResource("SelectResourceRevisionAction.InputRevisionPanel.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            resource = SVNUtility.copyOf((IRepositoryResource)resource);
            Revision selectedRevision = panel.getSelectedRevision();
            resource.setSelectedRevision(selectedRevision);
            LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource}, true);
            AddRevisionLinkOperation mainOp = new AddRevisionLinkOperation((IRepositoryResourceProvider)locateOp, selectedRevision);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)locateOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{locateOp});
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{location}, true));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.getSelectedRepositoryResources().length == 1;
    }
}

