/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.annotate;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.GetResourceAnnotationOperation;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.AbstractSVNView;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.annotate.AnnotateEditorInput;
import org.polarion.team.svn.ui.history.IRepositoryEditorInput;
import org.polarion.team.svn.ui.history.SVNHistoryPage;
import org.polarion.team.svn.ui.operation.OpenRemoteFileOperation;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class AnnotateView
extends AbstractSVNView {
    public static final String VIEW_ID;
    protected AnnotateEntry[] annotatedLines;
    protected TableViewer viewer;
    protected IEditorPart editor;
    protected SVNHistoryPage historyView;
    protected boolean canTrackSelection;
    private IPartListener editorStateListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == AnnotateView.this.editor) {
                AnnotateView.this.annotatedLines = new AnnotateEntry[0];
                AnnotateView.this.setTableInput();
                AnnotateView.this.editor.getSite().getPage().removePartListener((IPartListener)this);
                AnnotateView.this.editor = null;
                AnnotateView.this.historyView = null;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.ui.annotate.AnnotateView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public AnnotateView() {
        super(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.Name"));
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.getSite().getPage().removePartListener(this.editorStateListener);
            IWorkbench workbench = SVNTeamUIPlugin.instance().getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            page.closeEditor(this.editor, false);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer = this.createLogTable(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    AnnotateView.this.linesSelectionChanged(((IStructuredSelection)event.getSelection()).getFirstElement());
                }
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.setTableInput();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.polarion.team.svn.help.annotationViewContext");
    }

    public void showEditor(IResource resource) {
        this.showEditor(resource, null, null);
    }

    public void showEditor(IResource resource, Revision topRevision, Revision pegRevision) {
        SVNRemoteStorage storage;
        this.wcResource = resource;
        IRepositoryResource remoteResource = null;
        if (resource != null && (remoteResource = (storage = SVNRemoteStorage.instance()).asRepositoryResource(resource)) != null) {
            remoteResource.setSelectedRevision(topRevision);
            remoteResource.setPegRevision(pegRevision);
        }
        this.showEditorImpl(remoteResource);
    }

    public void showEditor(IRepositoryResource resource) {
        this.wcResource = null;
        this.showEditorImpl(resource);
    }

    protected void showEditorImpl(IRepositoryResource resource) {
        if (this.editor != null) {
            this.editor.getSite().getPage().closeEditor(this.editor, false);
        }
        this.repositoryResource = resource;
        this.showResourceLabel();
        if (resource == null) {
            this.showEditor((byte[])null);
            return;
        }
        final GetResourceAnnotationOperation annotateOp = new GetResourceAnnotationOperation(resource);
        AbstractNonLockingOperation showOp = new AbstractNonLockingOperation("Operation.AShowAnnotation"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                AnnotateView.this.getSite().getShell().getDisplay().syncExec(new Runnable(this, annotateOp){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ GetResourceAnnotationOperation val$annotateOp;
                    {
                        this.this$1 = var1_1;
                        this.val$annotateOp = getResourceAnnotationOperation;
                    }

                    public void run() {
                        String[][] lines = this.val$annotateOp.getAnnotatedLines();
                        ArrayList<AnnotateEntry> entries = new ArrayList<AnnotateEntry>();
                        AnnotateEntry entry = null;
                        int i = 0;
                        while (i < lines.length) {
                            if (entry == null) {
                                entry = 3.access$0(this.this$1).new AnnotateEntry();
                                entry.setRevision(lines[i][0]);
                                entry.setAuthor(lines[i][1]);
                                entry.setFirstLine(lines[i][2]);
                            } else if (!entry.getRevision().equals(lines[i][0])) {
                                entries.add(entry);
                                entry = 3.access$0(this.this$1).new AnnotateEntry();
                                entry.setRevision(lines[i][0]);
                                entry.setAuthor(lines[i][1]);
                                entry.setFirstLine(lines[i][2]);
                            } else {
                                entry.setLastLine(lines[i][2]);
                            }
                            ++i;
                        }
                        if (entry == null) {
                            3.access$0(this.this$1).showEditor((byte[])null);
                            MessageDialog dialog = new MessageDialog(3.access$0(this.this$1).getSite().getShell(), SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.NoContent.Title"), null, MessageFormat.format(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.NoContent.Message"), AnnotateView.access$0(3.access$0(this.this$1)).getName()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                            dialog.open();
                            return;
                        }
                        entries.add(entry);
                        3.access$0(this.this$1).annotatedLines = entries.toArray(new AnnotateEntry[entries.size()]);
                        3.access$0(this.this$1).showEditor(this.val$annotateOp.getContent());
                    }
                });
            }

            static /* synthetic */ AnnotateView access$0(3 var0) {
                return var0.AnnotateView.this;
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId());
        op.add((IActionOperation)annotateOp);
        op.add((IActionOperation)showOp, new IActionOperation[]{annotateOp});
        UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)this, (IActionOperation)op);
    }

    public void setFocus() {
    }

    protected void showEditor(byte[] data) {
        this.canTrackSelection = true;
        this.setTableInput();
        if (data == null) {
            return;
        }
        IWorkbench workbench = SVNTeamUIPlugin.instance().getWorkbench();
        final IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new AbstractNonLockingOperation("Operation.AShowHistoryPart"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IHistoryView view;
                if (AnnotateView.this.historyView == null && (view = (IHistoryView)page.showView("org.eclipse.team.ui.GenericHistoryView")) != null) {
                    AnnotateView.this.historyView = (SVNHistoryPage)view.showHistoryFor(AnnotateView.this.wcResource != null ? AnnotateView.this.wcResource : AnnotateView.this.repositoryResource);
                }
            }
        });
        AnnotateEditorInput input = new AnnotateEditorInput((IRepositoryFile)this.repositoryResource, data);
        OpenRemoteFileOperation op = new OpenRemoteFileOperation(new IRepositoryEditorInput[]{input}, 3, "org.eclipse.ui.DefaultTextEditor");
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
        IEditorPart[] editors = op.getEditors();
        if (op.getEditors() != null && op.getEditors().length > 0) {
            this.editor = editors[0];
            if (this.editor instanceof ITextEditor) {
                ((IPostSelectionProvider)((ITextEditor)this.editor).getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        AnnotateView.this.textSelectionChanged((ITextSelection)event.getSelection());
                    }
                });
            }
            this.editor.getSite().getPage().addPartListener(this.editorStateListener);
        }
    }

    protected void textSelectionChanged(ITextSelection selection) {
        if (this.annotatedLines.length > 0) {
            IStructuredSelection current;
            int line = selection.getStartLine() + 1;
            int idx = -1;
            int i = 0;
            while (i < this.annotatedLines.length) {
                if (Integer.parseInt(this.annotatedLines[i].getFirstLine()) <= line && Integer.parseInt(this.annotatedLines[i].getLastLine()) >= line) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (idx != -1 && ((current = (IStructuredSelection)this.viewer.getSelection()) == null || current.isEmpty() || current.getFirstElement() != this.annotatedLines[idx])) {
                this.canTrackSelection = false;
                String[] data = this.annotatedLines[idx].getData();
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.annotatedLines[idx]));
                if (this.historyView != null) {
                    this.historyView.selectRevision(Long.parseLong(data[0]));
                }
                this.canTrackSelection = true;
            }
        }
    }

    protected void linesSelectionChanged(Object selection) {
        if (!this.canTrackSelection || !(this.editor instanceof ITextEditor) || selection == null) {
            return;
        }
        AnnotateEntry entry = (AnnotateEntry)selection;
        final ITextEditor editor = (ITextEditor)this.editor;
        IDocumentProvider provider = editor.getDocumentProvider();
        final IDocument document = provider.getDocument((Object)editor.getEditorInput());
        final int selectedIdxStart = Integer.parseInt(entry.getFirstLine()) - 1;
        final int selectedIdxStop = Integer.parseInt(entry.getLastLine()) - 1;
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new AbstractNonLockingOperation("Operation.AChangeSelection"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                int length;
                int start = document.getLineOffset(selectedIdxStart);
                IRegion region = document.getLineInformation(selectedIdxStop);
                int stop = document.getLineOffset(selectedIdxStop) + region.getLength();
                if (stop < (length = document.getLength())) {
                    stop = document.getLineOffset(selectedIdxStop + 1);
                }
                editor.selectAndReveal(start, stop - start);
            }
        });
        if (this.historyView != null) {
            this.historyView.selectRevision(Long.parseLong(((AnnotateEntry)selection).getData()[0]));
        }
    }

    protected TableViewer createLogTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.Revision"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.Author"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setAlignment(131072);
        col.setText(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.Lines"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, true));
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return AnnotateView.this.repositoryResource == null ? new AnnotateEntry[]{} : AnnotateView.this.annotatedLines;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((AnnotateEntry)element).getData()[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        viewer.setInput((Object)this.annotatedLines);
        return viewer;
    }

    protected void setTableInput() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.setInput((Object)this.annotatedLines);
        }
    }

    protected void disconnectView() {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                AnnotateView.this.showEditor((IResource)null);
            }
        });
    }

    protected void refreshView() {
    }

    protected boolean needsLinkWithEditorAndSelection() {
        return false;
    }

    protected class AnnotateEntry {
        protected String[] data = new String[5];

        public String getRevision() {
            return this.data[0];
        }

        public void setRevision(String revision) {
            this.data[0] = revision;
        }

        public String getAuthor() {
            return this.data[1];
        }

        public void setAuthor(String author) {
            this.data[1] = author;
        }

        public String getFirstLine() {
            return this.data[3] == null ? this.data[4] : this.data[3];
        }

        public void setFirstLine(String line) {
            this.data[3] = line;
            this.makeLinesText();
        }

        public String getLastLine() {
            return this.data[4] == null ? this.data[3] : this.data[4];
        }

        public void setLastLine(String line) {
            this.data[4] = line;
            this.makeLinesText();
        }

        public String[] getData() {
            return this.data;
        }

        protected void makeLinesText() {
            if (this.data[3] != null) {
                if (this.data[4] != null) {
                    int lines = Integer.parseInt(this.data[4]) - Integer.parseInt(this.data[3]) + 1;
                    this.data[2] = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.MultiLine"), String.valueOf(lines), this.data[3], this.data[4]);
                } else {
                    this.data[2] = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("SVNAnnotateView.OneLine"), this.data[3]);
                }
            } else {
                this.data[2] = this.data[4];
            }
        }
    }
}

